/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client.screens;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5253;
import net.woukie.createmissiles.inventory.NavigationPanelMenu;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class NavigationPanelScreen
extends class_465<NavigationPanelMenu> {
    private static final class_2960 BACKGROUND = new class_2960("createmissiles", "textures/gui/container/navigation_panel.png");
    private static final class_2960 MAP_ERROR = new class_2960("createmissiles", "textures/gui/sprites/container/map_error.png");
    private static final class_2960 NO_MAP = new class_2960("createmissiles", "textures/gui/sprites/container/no_map.png");
    private static final class_2960 MAP_TARGET_HORIZONTAL = new class_2960("createmissiles", "textures/gui/sprites/container/target_horizontal.png");
    private static final class_2960 MAP_TARGET_VERTICAL = new class_2960("createmissiles", "textures/gui/sprites/container/target_vertical.png");
    private static final class_2960 MAP_TARGET = new class_2960("createmissiles", "textures/gui/sprites/container/target_marker.png");
    private static final class_2960 TRAJECTORY_NO_MAP = new class_2960("createmissiles", "textures/gui/sprites/container/trajectory_no_map.png");
    private static final class_2960 TRAJECTORY_TARGET_LOADING = new class_2960("createmissiles", "textures/gui/sprites/container/trajectory_target_loading.png");
    private static final class_2960 INVALID_SETUP = new class_2960("createmissiles", "textures/gui/sprites/container/invalid_setup.png");
    private static final class_2960 FUEL = new class_2960("createmissiles", "textures/gui/sprites/container/fuel.png");
    private static final class_2960 WHITE_DOT = new class_2960("createmissiles", "textures/gui/sprites/container/white_dot.png");
    private static final class_2960 FUEL_GAUGE = new class_2960("createmissiles", "textures/gui/sprites/container/fuel_gauge.png");
    private static final class_2960 MIN_THRUST_DURATION = new class_2960("createmissiles", "textures/gui/sprites/container/min_thrust_duration.png");
    private static final int mapLeft = 8;
    private static final int mapTop = 16;
    private static final int mapWidth = 54;
    private static final int mapHeight = 54;
    private static final int fuelLeft = 106;
    private static final int fuelTop = 16;
    private static final int fuelWidth = 5;
    private static final int fuelHeight = 54;
    private static final int trajectoryLeft = 114;
    private static final int trajectoryTop = 16;
    private static final int trajectoryWidth = 53;
    private static final int trajectoryHeight = 53;
    private static final int trajectoryPadding = 2;
    private double currentMapCrosshairX = 0.0;
    private double currentMapCrosshairZ = 0.0;
    private double currentFuel1 = 0.0;
    private double currentFuel2 = 0.0;
    private double currentMinThrustDuration1 = 0.0;
    private double currentMinThrustDuration2 = 0.0;
    private double maxThrustDuration = 0.0;
    private double minThrustDuration = 0.0;
    private final List<Vector2d> positions = new ArrayList<Vector2d>();
    private double maxHeight = 256.0;
    private double lastFuelPercent = 0.0;
    private double distanceToTarget = 0.0;
    private class_2338 lastTargetPos = new class_2338(0, 0, 0);
    private Float lastUpperLaunchAngle = null;
    private Float lastLowerLaunchAngle = null;

    public NavigationPanelScreen(NavigationPanelMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)abstractContainerMenu, inventory, component);
    }

    public void method_25394(@NotNull class_332 gui, int i, int j, float f) {
        super.method_25394(gui, i, j, f);
        this.method_2380(gui, i, j);
        this.renderCrosshair(gui);
    }

    protected void method_2389(class_332 gui, float f, int i, int j) {
        gui.method_51448().method_22903();
        gui.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, -1.0f);
        gui.method_25302(BACKGROUND, 0, 0, 0, 0, this.field_2792, this.field_2779);
        this.simulateTrajectory();
        this.renderMap(gui);
        this.renderFuel(gui);
        this.renderTrajectory(gui);
        this.renderText(gui);
        gui.method_51448().method_22909();
    }

    public boolean method_25402(double x, double z, int i) {
        if (this.method_2378(8, 16, 54, 54, x, z)) {
            double mapCrosshairX = (x - (double)this.field_2776 - 8.0) * 2.3703703703703702;
            double mapCrosshairZ = (z - (double)this.field_2800 - 16.0) * 2.3703703703703702;
            class_1799 map = ((NavigationPanelMenu)this.method_17577()).getMap();
            if (this.field_22787 == null || this.field_22787.field_1687 == null || map == null || class_1806.method_8001((class_1799)map, (class_1937)this.field_22787.field_1687) == null) {
                return super.method_25402(x, z, i);
            }
            ((NavigationPanelMenu)this.method_17577()).clickMap(mapCrosshairX, mapCrosshairZ);
        }
        if (this.method_2378(106, 16, 5, 54, x, z)) {
            double fuelClickZ = z - (double)this.field_2800 - 16.0;
            ((NavigationPanelMenu)this.method_17577()).clickFuel((float)(1.0 - fuelClickZ / 54.0));
        }
        return super.method_25402(x, z, i);
    }

    private void renderMap(class_332 gui) {
        assert (this.field_22787 != null && this.field_22787.field_1687 != null);
        class_1799 mapItem = ((NavigationPanelMenu)this.method_17577()).getMap();
        if (mapItem == null) {
            gui.method_25291(NO_MAP, 8, 16, 5, 0.0f, 0.0f, 54, 54, 54, 54);
            return;
        }
        Integer mapId = class_1806.method_8003((class_1799)mapItem);
        class_22 mapData = class_1806.method_7997((Integer)mapId, (class_1937)this.field_22787.field_1687);
        if (mapId == null || mapData == null) {
            gui.method_25291(MAP_ERROR, 8, 16, 5, 0.0f, 0.0f, 54, 54, 54, 54);
            return;
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(8.0f, 16.0f, 1.0f);
        gui.method_51448().method_22905(0.421875f, 0.421875f, 1.0f);
        this.field_22787.field_1773.method_3194().method_1773(gui.method_51448(), (class_4597)gui.method_51450(), mapId.intValue(), mapData, true, 0xF000F0);
        gui.method_51448().method_22909();
    }

    private void renderCrosshair(class_332 gui) {
        int targetMapCrosshairX = ((NavigationPanelMenu)this.method_17577()).getMapCrosshairX();
        int targetMapCrosshairZ = ((NavigationPanelMenu)this.method_17577()).getMapCrosshairZ();
        this.currentMapCrosshairX += ((double)targetMapCrosshairX - this.currentMapCrosshairX) * (double)0.1f;
        this.currentMapCrosshairZ += ((double)targetMapCrosshairZ - this.currentMapCrosshairZ) * (double)0.1f;
        int scaledX = (int)(this.currentMapCrosshairX * 54.0 / 128.0);
        int scaledY = (int)(this.currentMapCrosshairZ * 54.0 / 128.0);
        gui.method_51448().method_22903();
        gui.method_51448().method_46416((float)(8 + this.field_2776), (float)(16 + this.field_2800), 10.0f);
        int scissorLeft = this.field_2776 + 8;
        int scissorTop = this.field_2800 + 16;
        gui.method_44379(scissorLeft - 1, scissorTop - 1, scissorLeft + 54 + 1, scissorTop + 54 + 1);
        gui.method_25291(MAP_TARGET, scaledX - 4, scaledY - 4, 2, 0.0f, 0.0f, 9, 9, 9, 9);
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        gui.method_25291(MAP_TARGET_VERTICAL, scaledX - 2, -4, 1, 0.0f, 0.0f, 5, 62, 5, 62);
        gui.method_25291(MAP_TARGET_HORIZONTAL, -4, scaledY - 2, 1, 0.0f, 0.0f, 62, 5, 62, 5);
        gui.method_51448().method_22909();
        gui.method_44380();
        gui.method_51448().method_22909();
    }

    private void renderTrajectory(class_332 gui) {
        assert (this.field_22787 != null);
        if (!((NavigationPanelMenu)this.method_17577()).launchPadExists() || ((NavigationPanelMenu)this.method_17577()).assemblyPanelAbsent()) {
            gui.method_25291(INVALID_SETUP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        class_1799 mapItem = ((NavigationPanelMenu)this.method_17577()).getMap();
        if (mapItem == null) {
            gui.method_25291(TRAJECTORY_NO_MAP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        class_2338 source = ((NavigationPanelMenu)this.method_17577()).getSource();
        class_2338 target = ((NavigationPanelMenu)this.method_17577()).getTarget();
        if (source == null || target == null) {
            gui.method_25291(TRAJECTORY_TARGET_LOADING, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        class_1799 warhead = ((NavigationPanelMenu)this.method_17577()).getWarhead();
        class_1799 chassis = ((NavigationPanelMenu)this.method_17577()).getChassis();
        class_1799 thruster = ((NavigationPanelMenu)this.method_17577()).getThruster();
        if (warhead == null || chassis == null || thruster == null) {
            gui.method_25291(INVALID_SETUP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        if (this.positions.isEmpty()) {
            return;
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(116.0f, 18.0f, 0.0f);
        double yBottom = Math.min(target.method_10264(), source.method_10264());
        double yTop = this.maxHeight;
        double xStart = 0.0;
        double xEnd = Vector3d.distance((double)target.method_10263(), (double)0.0, (double)target.method_10260(), (double)source.method_10263(), (double)0.0, (double)source.method_10260());
        int width = 49;
        int height = 49;
        int xLine = Math.max((int)this.mapRange(source.method_10264(), yBottom, yTop, 0.0, height), 0);
        if (xLine < height) {
            gui.method_25292(0, width, height - xLine, 0x77FFFFFF);
        }
        gui.method_25301(0, 0, height, 0x77FFFFFF);
        Vector2i lastPixelPos = null;
        for (int i = 0; i < width; ++i) {
            Vector2d currentPos = this.positions.get(i * this.positions.size() / width);
            Vector2i currentPixelPos = new Vector2i((int)this.mapRange(currentPos.x, xStart, xEnd, 0.0, width), (int)this.mapRange(currentPos.y, yBottom, yTop, 0.0, height));
            if (lastPixelPos != null) {
                this.traverseLine(currentPixelPos, lastPixelPos, interpPos -> {
                    Vector2i p = new Vector2i((int)interpPos.x, (int)interpPos.y);
                    if (p.y < 0 || p.y > height || p.x < 0 || p.x > width) {
                        return;
                    }
                    gui.method_25292(p.x, p.x, height - p.y, -1);
                });
            }
            lastPixelPos = currentPixelPos;
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        float redness = -((float)Math.pow(-(this.distanceToTarget / 10.0 + 1.0), -1.0));
        int colour = class_5253.class_5254.method_48780((float)redness, (int)0xFF0000, (int)0xFFFFFF);
        gui.method_25303(this.field_22793, new DecimalFormat("#0.00").format(this.distanceToTarget) + "m", 0, 0, colour);
        gui.method_51448().method_22909();
        gui.method_51448().method_22909();
    }

    private void renderText(class_332 gui) {
        gui.method_51448().method_22903();
        float scale = 0.5f;
        gui.method_51448().method_22905(scale, scale, scale);
        String textTime = Double.toString(this.maxThrustDuration);
        int paddingX = 3;
        gui.method_51433(this.field_22793, textTime, (int)((float)(106 - this.field_22793.method_1727(textTime) - paddingX) / scale), (int)(14.0f / scale), 0, false);
        String textDeltaT = "\u0394t";
        gui.method_51433(this.field_22793, textDeltaT, (int)((float)(106 - this.field_22793.method_1727(textDeltaT) - paddingX) / scale), (int)(68.0f / scale), 0, false);
        gui.method_51448().method_22909();
    }

    private void renderFuel(class_332 gui) {
        this.currentFuel1 += (((NavigationPanelMenu)this.method_17577()).getFuelPercent() - this.currentFuel2) * 0.1;
        this.currentFuel2 += (this.currentFuel1 - this.currentFuel2) * 0.1;
        int barHeight = 54 - (int)(this.currentFuel2 * 54.0);
        barHeight = Math.min(Math.max(barHeight, 1), 54);
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(106.0f, 16.0f, 0.0f);
        gui.method_25291(FUEL, 0, barHeight, 0, 0.0f, (float)barHeight, 5, 54 - barHeight, 5, barHeight);
        gui.method_25291(FUEL_GAUGE, -2, barHeight - 3, 1, 0.0f, 0.0f, 9, 5, 9, 5);
        gui.method_51448().method_22909();
    }

    private void simulateTrajectory() {
        class_2338 target = ((NavigationPanelMenu)this.method_17577()).getTarget();
        if (target == null) {
            this.distanceToTarget = 0.0;
            this.positions.clear();
            return;
        }
        if (target.equals((Object)this.lastTargetPos) && this.lastFuelPercent == ((NavigationPanelMenu)this.method_17577()).getFuelPercent() && this.lastUpperLaunchAngle.floatValue() == ((NavigationPanelMenu)this.method_17577()).getUpperLaunchAngle() && this.lastLowerLaunchAngle.floatValue() == ((NavigationPanelMenu)this.method_17577()).getLowerLaunchAngle()) {
            return;
        }
        this.lastTargetPos = ((NavigationPanelMenu)this.method_17577()).getTarget();
        this.lastFuelPercent = ((NavigationPanelMenu)this.method_17577()).getFuelPercent();
        this.lastUpperLaunchAngle = Float.valueOf(((NavigationPanelMenu)this.method_17577()).getUpperLaunchAngle());
        this.lastLowerLaunchAngle = Float.valueOf(((NavigationPanelMenu)this.method_17577()).getLowerLaunchAngle());
        WarheadType warheadType = (WarheadType)PartTypes.get(((NavigationPanelMenu)this.method_17577()).getWarhead());
        ChassisType chassisType = (ChassisType)PartTypes.get(((NavigationPanelMenu)this.method_17577()).getChassis());
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(((NavigationPanelMenu)this.method_17577()).getThruster());
        if (warheadType == null || chassisType == null || thrusterType == null) {
            return;
        }
        this.maxThrustDuration = chassisType.getFuelCapacity() / thrusterType.getBurnRate();
        class_2338 source = ((NavigationPanelMenu)this.method_17577()).getSource();
        Vector3d start = new Vector3d((double)source.method_10263(), (double)source.method_10264(), (double)source.method_10260()).add(0.5, 0.5, 0.5);
        Vector3d end = new Vector3d((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260()).add(0.5, 0.5, 0.5);
        float launchAngle = (((NavigationPanelMenu)this.method_17577()).getLowerLaunchAngle() + ((NavigationPanelMenu)this.method_17577()).getUpperLaunchAngle()) / 2.0f;
        this.positions.clear();
        BallisticTrajectory simulatedTrajectory = new BallisticTrajectory(new Vector3d((Vector3dc)start), new Vector3d((Vector3dc)end), warheadType, chassisType, thrusterType, launchAngle, ((NavigationPanelMenu)this.method_17577()).getFuelPercent());
        double minDistance = Double.POSITIVE_INFINITY;
        double previousDistance = Double.POSITIVE_INFINITY;
        while (true) {
            boolean descending;
            Vector3d currentPosition = new Vector3d((Vector3dc)simulatedTrajectory.getPosition());
            if (Double.isNaN(currentPosition.x)) break;
            Vector2d currentPosition2D = new Vector2d(new Vector2d(currentPosition.x, currentPosition.z).distance((Vector2dc)new Vector2d(start.x, start.z)), currentPosition.y);
            this.positions.add(currentPosition2D);
            double currentDistance = end.distance((Vector3dc)currentPosition);
            minDistance = Math.min(minDistance, currentDistance);
            boolean bl = descending = simulatedTrajectory.getVelocity().y < 0.0;
            if (descending && currentDistance > previousDistance) break;
            previousDistance = currentDistance;
            simulatedTrajectory.tick();
        }
        this.distanceToTarget = minDistance;
        BallisticTrajectory maxFuelSimulatedTrajectory = new BallisticTrajectory(new Vector3d((Vector3dc)start), new Vector3d((Vector3dc)end), warheadType, chassisType, thrusterType, launchAngle, 1.0);
        while (!(maxFuelSimulatedTrajectory.getVelocity().y < 0.0)) {
            this.maxHeight = maxFuelSimulatedTrajectory.getPosition().y;
            if (Double.isNaN(this.maxHeight)) break;
            maxFuelSimulatedTrajectory.tick();
        }
    }

    private void traverseLine(Vector2i startI, Vector2i endI, Consumer<Vector2d> callback) {
        Vector2d start = new Vector2d((double)startI.x, (double)startI.y);
        Vector2d end = new Vector2d((double)endI.x, (double)endI.y);
        Vector2d currentPos = new Vector2d((Vector2dc)start);
        Vector2d increment = new Vector2d((Vector2dc)end).sub((Vector2dc)start).normalize();
        double distanceSqr = currentPos.distanceSquared((Vector2dc)end);
        while (currentPos.distanceSquared((Vector2dc)start) < distanceSqr) {
            callback.accept(new Vector2d((Vector2dc)currentPos));
            currentPos.add((Vector2dc)increment);
        }
    }

    private double mapRange(double value, double oldMin, double oldMax, double newMin, double nawMax) {
        return newMin + (value - oldMin) * (nawMax - newMin) / (oldMax - oldMin);
    }
}

