/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1309;
import net.minecraft.class_1900;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.ExplosionResistanceOverrides;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplodingAreaWorker;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Explosion {
    public static final int EXPLOSION_CHUNKS = 2;
    private final class_2338 originBlockPosition;
    private final double power;
    private final double decay;
    private final class_5321<class_1937> levelKey;
    private final class_1937 level;
    private class_2499 workerData;
    private final List<ExplodingAreaWorker> workers = new ArrayList<ExplodingAreaWorker>();
    private final int maxRadius;
    private final ConcurrentHashMap<class_2338, Float> hardnessMap;
    private boolean complete = false;
    private boolean endEarly = false;

    public Explosion(class_1937 level, class_243 originPosition, double power) {
        this(level, originPosition, power, 0.3);
    }

    public Explosion(class_1937 level, class_243 originPosition, double power, double decay) {
        this.levelKey = level.method_27983();
        this.level = level;
        this.originBlockPosition = class_2338.method_49638((class_2374)originPosition);
        this.power = power;
        this.decay = decay;
        this.maxRadius = (int)((this.power - this.decay - 0.315) / 0.315);
        this.hardnessMap = new ConcurrentHashMap((int)(4.1887902047863905 * (double)this.maxRadius * (double)this.maxRadius * (double)this.maxRadius), 0.75f, 8);
    }

    public void damageEntities() {
        class_243 c1 = this.originBlockPosition.method_46558().method_1020(new class_243((double)this.maxRadius, (double)this.maxRadius, (double)this.maxRadius));
        class_243 c2 = this.originBlockPosition.method_46558().method_1019(new class_243((double)this.maxRadius, (double)this.maxRadius, (double)this.maxRadius));
        List entities = this.level.method_8335(null, new class_238(c1.field_1352, c1.field_1351, c1.field_1350, c2.field_1352, c2.field_1351, c2.field_1350));
        entities.forEach(entity -> {
            if (!(entity instanceof class_1309)) {
                return;
            }
            if (entity.method_5659()) {
                return;
            }
            double proximity = Math.sqrt(entity.method_5707(this.originBlockPosition.method_46558()));
            double proportionToEdge = proximity / (double)this.maxRadius;
            double proportionToCenter = 1.0 - proportionToEdge;
            if (!(proportionToEdge <= 1.0)) {
                return;
            }
            AtomicReference<Float> totalHardness = new AtomicReference<Float>(Float.valueOf(0.0f));
            AtomicReference<Integer> passedCount = new AtomicReference<Integer>(0);
            Vector3d origin = new Vector3d((double)this.originBlockPosition.method_10263(), (double)this.originBlockPosition.method_10264(), (double)this.originBlockPosition.method_10260()).add(0.5, 0.5, 0.5);
            Vector3d target = new Vector3d(entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350);
            double startPower = this.power;
            Util.traverseSupercover(origin, target, traversedPos -> {
                double distance = traversedPos.distance((Vector3dc)origin);
                if (distance > (double)this.maxRadius) {
                    return true;
                }
                class_2338 traversedBlockPos = class_2338.method_49637((double)traversedPos.x, (double)traversedPos.y, (double)traversedPos.z);
                float hardness = ExplosionResistanceOverrides.getResistance(this.level.method_8320(traversedBlockPos).method_26204());
                totalHardness.updateAndGet(current -> Float.valueOf(current.floatValue() + hardness));
                passedCount.updateAndGet(a -> {
                    a = a + 1;
                    return a;
                });
                int passedBlocks = Math.max((Integer)passedCount.get(), 1);
                double averageHardness = (double)((Float)totalHardness.get()).floatValue() / (double)passedBlocks;
                double powerLeft = startPower - (0.3 * (averageHardness / 5.0) + 0.315 + this.decay) * distance;
                return powerLeft <= 0.0;
            });
            double distance = target.distance((Vector3dc)origin);
            int passedBlocks = Math.max(passedCount.get(), 1);
            double averageHardness = (double)totalHardness.get().floatValue() / (double)passedBlocks;
            double powerLeft = startPower - (0.3 * (averageHardness / 5.0) + 0.315 + this.decay) * distance;
            if (powerLeft <= 0.0) {
                return;
            }
            double exposure = powerLeft / this.power;
            exposure = exposure >= 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * exposure);
            double impact = proportionToCenter * exposure;
            entity.method_5643(this.level.method_48963().method_48819(null, null), (float)((int)(impact * impact * impact * 7.0 * this.power + 1.0)));
            exposure = class_1900.method_8237((class_1309)((class_1309)entity), (double)exposure);
            entity.method_18799(entity.method_18798().method_1019(entity.method_19538().method_1020(this.originBlockPosition.method_46558()).method_1029().method_1021(exposure)));
        });
    }

    public void startCrunching() {
        int chunkSize = this.maxRadius * 2 / 2;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    class_2338 start = this.originBlockPosition.method_10069(-this.maxRadius + chunkSize * x, -this.maxRadius + chunkSize * y, -this.maxRadius + chunkSize * z);
                    class_2338 end = start.method_10069(chunkSize, chunkSize, chunkSize);
                    ExplodingAreaWorker worker = new ExplodingAreaWorker(start, end, this.originBlockPosition, this.level, this.power, this.hardnessMap, this.decay);
                    int i = x * 4 + y * 2 + z;
                    if (this.workerData != null && this.workerData.size() > i) {
                        worker.load((class_2487)this.workerData.method_10534(i));
                    }
                    Thread thread = new Thread(worker);
                    this.workers.add(worker);
                    thread.start();
                }
            }
        }
        CreateMissiles.LOGGER.info("Started explosion workers at {}", (Object)this.originBlockPosition.method_23854());
        this.workerData = null;
    }

    public void serverTick(MinecraftServer server) {
        boolean keepDestroying = true;
        this.complete = true;
        while (keepDestroying) {
            keepDestroying = false;
            for (ExplodingAreaWorker worker : this.workers) {
                if (worker.isComplete()) continue;
                this.complete = false;
                if (this.endEarly) {
                    return;
                }
                if (!worker.processBlock(this.level)) continue;
                keepDestroying = true;
            }
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public class_2487 save() {
        class_2487 hardnessData = new class_2487();
        hardnessData.method_10538("Keys", this.hardnessMap.keySet().stream().map(class_2338::method_10063).toList());
        hardnessData.method_36110("Values", this.hardnessMap.values().stream().map(Float::byteValue).toList());
        class_2499 workerList = new class_2499();
        workerList.addAll(this.workers.stream().map(ExplodingAreaWorker::save).toList());
        class_2487 data = new class_2487();
        data.method_10582("Level", this.levelKey.method_29177().method_12832());
        data.method_10569("PositionX", this.originBlockPosition.method_10263());
        data.method_10569("PositionY", this.originBlockPosition.method_10264());
        data.method_10569("PositionZ", this.originBlockPosition.method_10260());
        data.method_10566("Workers", (class_2520)workerList);
        data.method_10549("Power", this.power);
        data.method_10566("Hardness", (class_2520)hardnessData);
        return data;
    }

    public static Explosion load(class_2487 data, MinecraftServer server) {
        class_3218 level = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(data.method_10558("Level"))));
        class_243 origin = new class_243((double)data.method_10550("PositionX"), (double)data.method_10550("PositionY"), (double)data.method_10550("PositionZ"));
        if (level == null) {
            return null;
        }
        Explosion explosion = new Explosion((class_1937)level, origin, data.method_10574("Power"));
        class_2487 hardnessData = data.method_10562("Hardness");
        long[] hardnessKeys = hardnessData.method_10565("Keys");
        byte[] hardnessValues = hardnessData.method_10547("Values");
        for (int i = 0; i < hardnessKeys.length; ++i) {
            explosion.hardnessMap.put(class_2338.method_10092((long)hardnessKeys[i]), Float.valueOf(hardnessValues[i]));
        }
        explosion.workerData = data.method_10554("Workers", 10);
        return explosion;
    }

    public void stopCrunching() {
        this.endEarly = true;
        this.workers.forEach(ExplodingAreaWorker::endEarly);
    }

    public class_2338 getOrigin() {
        return this.originBlockPosition;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public double getPower() {
        return this.power;
    }
}

