/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3222;
import net.minecraft.class_5253;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.client.CreateFlashMessage;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.registry.Packets;
import org.jetbrains.annotations.NotNull;

public class ExplosionHandler
extends class_18 {
    private List<Explosion> explosions = new ArrayList<Explosion>();
    private static MinecraftServer server;
    private static ExplosionHandler instance;
    private static boolean initialized;
    private static boolean destroyOnSave;

    private ExplosionHandler() {
    }

    public static ExplosionHandler get() {
        if (instance == null) {
            instance = new ExplosionHandler();
        }
        return instance;
    }

    public void createExplosion(Explosion explosion) {
        this.createExplosion(explosion, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)251), 1000);
    }

    public void createExplosion(Explosion explosion, Integer colour, Integer length) {
        this.explosions.add(explosion);
        explosion.damageEntities();
        explosion.startCrunching();
        explosion.getLevel().method_18456().forEach(player -> {
            double distance = player.method_19538().method_1022(explosion.getOrigin().method_46558());
            if (distance < (double)(explosion.getMaxRadius() * 4)) {
                Packets.CREATE_FLASH.sendToPlayer((class_3222)player, (Object)new CreateFlashMessage(colour, explosion.getOrigin(), explosion.getMaxRadius(), explosion.getPower(), length));
            }
        });
        this.method_80();
    }

    @NotNull
    public class_2487 method_75(class_2487 compoundTag) {
        CreateMissiles.LOGGER.info("Saving explosions");
        class_2499 explosions = new class_2499();
        explosions.addAll(this.explosions.stream().map(Explosion::save).toList());
        compoundTag.method_10566("Explosions", (class_2520)explosions);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            server = null;
            this.explosions.clear();
            instance = null;
        }
        return compoundTag;
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.explosions.forEach(Explosion::stopCrunching);
        this.method_80();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        this.explosions.removeIf(explosion -> {
            explosion.serverTick(server);
            if (explosion.isComplete()) {
                CreateMissiles.LOGGER.info("Explosion at {} is complete", (Object)explosion.getOrigin().method_23854());
                this.method_80();
                return true;
            }
            return false;
        });
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        ExplosionHandler.server = server;
        class_26 storage = server.method_30002().method_17983();
        storage.method_17924(this::load, () -> this, "Explosions");
    }

    public ExplosionHandler load(class_2487 nbt) {
        this.explosions = new ArrayList<Explosion>(nbt.method_10554("Explosions", 10).stream().map(tag -> Explosion.load((class_2487)tag, server)).toList());
        CreateMissiles.LOGGER.info("Explosions loaded");
        this.explosions.forEach(Explosion::startCrunching);
        return this;
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

