/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.registry.PartTypes;
import net.woukie.createmissiles.registry.RecipeSerializers;
import net.woukie.createmissiles.registry.RecipeTypes;
import org.jetbrains.annotations.NotNull;

public class MissilePartRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final class_2371<MissileIngredient> ingredients;
    private final class_2960 assembly;

    public MissilePartRecipe(class_2960 id, class_2371<MissileIngredient> ingredients, class_2960 assembly) {
        this.id = id;
        this.ingredients = ingredients;
        this.assembly = assembly;
    }

    public class_2960 getAssembly() {
        return this.assembly;
    }

    public boolean itemComplements(class_1799 itemStack, class_1263 container) {
        ArrayList<class_1799> stacksLeft = new ArrayList<class_1799>();
        MissilePartType partType = PartTypes.get(this.assembly);
        for (int i = partType.getStartSlot(); i < partType.getEndSlot(); ++i) {
            if (container.method_5438(i).method_7960()) continue;
            stacksLeft.add(container.method_5438(i));
        }
        Map<MissileIngredient, Integer> remainingItems = this.getRemainingItems(stacksLeft);
        for (Map.Entry<MissileIngredient, Integer> item : remainingItems.entrySet()) {
            if (!item.getKey().test(itemStack) || item.getValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public class_2371<MissileIngredient> getMissileIngredients() {
        return this.ingredients;
    }

    public Map<MissileIngredient, Integer> getRemainingItems(List<class_1799> items) {
        Map<MissileIngredient, Integer> ingredientStatus = this.getMissileIngredients().stream().collect(Collectors.toMap(a -> a, MissileIngredient::count));
        block0: for (class_1799 item : items) {
            int itemsRemaining = item.method_7947();
            for (MissileIngredient ingredient : ingredientStatus.keySet()) {
                Integer count = ingredientStatus.get(ingredient);
                if (ingredient.test(item)) {
                    int reducedTo = Math.max(count - itemsRemaining, 0);
                    ingredientStatus.put(ingredient, reducedTo);
                    itemsRemaining -= count - reducedTo;
                }
                if (itemsRemaining != 0) continue;
                continue block0;
            }
        }
        return ingredientStatus;
    }

    public static Optional<MissilePartRecipe> fromResourceLocation(class_1937 level, class_2960 resourceLocation) {
        if (level == null) {
            return Optional.empty();
        }
        List missilePartRecipes = level.method_8433().method_30027((class_3956)RecipeTypes.MISSILE_PART.get());
        return missilePartRecipes.stream().filter(r -> r.getAssembly().equals((Object)resourceLocation)).findFirst();
    }

    public static Map<MissileIngredient, Integer> getRemainingItems(MissilePartType partType, class_1937 level, List<class_1799> items) {
        if (partType == null) {
            return null;
        }
        Optional<MissilePartRecipe> recipe = MissilePartRecipe.fromResourceLocation(level, partType.getResourceLocation());
        return recipe.map(missilePartRecipe -> missilePartRecipe.getRemainingItems(items.subList(partType.getStartSlot(), partType.getEndSlot()))).orElse(null);
    }

    public static int getBuildPercentage(Map<MissileIngredient, Integer> remainingItems) {
        if (remainingItems == null) {
            return 0;
        }
        int totalCount = 0;
        int fulfilled = 0;
        for (Map.Entry<MissileIngredient, Integer> entry : remainingItems.entrySet()) {
            int required = entry.getKey().count();
            totalCount += entry.getKey().count();
            fulfilled += required - entry.getValue();
        }
        return (int)((float)fulfilled / (float)totalCount * 100.0f);
    }

    public static int getBuildPercentage(MissilePartType partType, class_1937 level, List<class_1799> items) {
        if (partType == null || level == null) {
            return 0;
        }
        Map<MissileIngredient, Integer> remainingItems = MissilePartRecipe.getRemainingItems(partType, level, items);
        return MissilePartRecipe.getBuildPercentage(remainingItems);
    }

    public boolean method_8115(@NotNull class_1263 container, @NotNull class_1937 level) {
        ArrayList<class_1799> containerStacks = new ArrayList<class_1799>();
        MissilePartType partType = PartTypes.get(this.assembly);
        for (int i = partType.getStartSlot(); i < partType.getEndSlot(); ++i) {
            if (container.method_5438(i).method_7960()) continue;
            containerStacks.add(container.method_5438(i));
        }
        Map<MissileIngredient, Integer> remainingItems = this.getRemainingItems(containerStacks);
        for (Map.Entry<MissileIngredient, Integer> remainingItem : remainingItems.entrySet()) {
            if (remainingItem.getValue() <= 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_8116(@NotNull class_1263 container, @NotNull class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeSerializers.MISSILE_PART.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypes.MISSILE_PART.get();
    }

    public static class Serializer
    implements class_1865<MissilePartRecipe> {
        @NotNull
        public MissilePartRecipe fromJson(@NotNull class_2960 resourceLocation, @NotNull JsonObject jsonObject) {
            class_2371<MissileIngredient> ingredients = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            class_2960 assembly = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"assembly"));
            return new MissilePartRecipe(resourceLocation, ingredients, assembly);
        }

        private static class_2371<MissileIngredient> itemsFromJson(JsonArray jsonArray) {
            class_2371 items = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                MissileIngredient ingredient = MissileIngredient.fromJson(jsonArray.get(i), false);
                if (ingredient.isEmpty()) continue;
                items.add((Object)ingredient);
            }
            return items;
        }

        @NotNull
        public MissilePartRecipe fromNetwork(@NotNull class_2960 resourceLocation, class_2540 friendlyByteBuf) {
            int ingredientCount = friendlyByteBuf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientCount, (Object)MissileIngredient.EMPTY);
            ingredients.replaceAll(ignored -> MissileIngredient.fromNetwork(friendlyByteBuf));
            class_2960 assembly = friendlyByteBuf.method_10810();
            return new MissilePartRecipe(resourceLocation, (class_2371<MissileIngredient>)ingredients, assembly);
        }

        public void toNetwork(class_2540 friendlyByteBuf, MissilePartRecipe recipe) {
            friendlyByteBuf.method_10804(recipe.ingredients.size());
            for (MissileIngredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(friendlyByteBuf);
            }
            friendlyByteBuf.method_10812(recipe.assembly);
        }
    }
}

