/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.woukie.createmissiles.block.controlpanel.ControlPanelBlockEntity;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlockEntity;
import net.woukie.createmissiles.registry.BlockEntities;

public class MultiblockHelper {
    public static BlockPos findCorner(BlockPos origin, Direction facing, Level level) {
        Direction right = facing.m_122427_();
        for (int offset = 0; offset < 3; ++offset) {
            BlockPos corner = origin.m_121945_(facing).m_5484_(right, -offset);
            if (!MultiblockHelper.checkForLaunchPad(corner, right, facing, level)) continue;
            return corner;
        }
        return null;
    }

    public static BlockEntity findEdgeBlock(BlockEntity origin, Level level, BlockEntityType<?> type) {
        Direction facing = ((Direction)origin.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockPos corner = MultiblockHelper.findCorner(origin.m_58899_(), facing, level);
        return MultiblockHelper.findEdgeBlock(corner, facing, level, type);
    }

    public static BlockEntity findEdgeBlock(BlockPos corner, Direction facing, Level level, BlockEntityType<?> type) {
        if (corner == null) {
            return null;
        }
        Direction right = facing.m_122427_();
        for (int i = 0; i < 3; ++i) {
            BlockPos leftEdge = corner.m_5484_(right, -1).m_5484_(facing, i);
            BlockEntity leftEntity = level.m_7702_(leftEdge);
            if (leftEntity != null && leftEntity.m_58903_() == type && leftEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == right.m_122424_()) {
                return leftEntity;
            }
            BlockPos farEdge = corner.m_5484_(facing, 3).m_5484_(right, i);
            BlockEntity farEntity = level.m_7702_(farEdge);
            if (farEntity != null && farEntity.m_58903_() == type && farEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == facing) {
                return farEntity;
            }
            BlockPos backEdge = corner.m_5484_(facing, -1).m_5484_(right, i);
            BlockEntity backEntity = level.m_7702_(backEdge);
            if (backEntity != null && backEntity.m_58903_() == type && backEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == facing.m_122424_()) {
                return backEntity;
            }
            BlockPos rightEdge = corner.m_5484_(right, 3).m_5484_(facing, i);
            BlockEntity rightEntity = level.m_7702_(rightEdge);
            if (rightEntity == null || rightEntity.m_58903_() != type || rightEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != right) continue;
            return rightEntity;
        }
        return null;
    }

    private static boolean checkForLaunchPad(BlockPos corner, Direction right, Direction facing, Level level) {
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                BlockPos targetBlock = corner.m_5484_(right, x).m_5484_(facing, z);
                BlockEntity blockEntity = level.m_7702_(targetBlock);
                if (blockEntity instanceof LaunchPadBlockEntity) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos findCornerFromLaunchPad(Level level, BlockPos pos) {
        Direction forward = Direction.NORTH;
        Direction right = forward.m_122427_();
        BlockPos corner = pos;
        while (level.m_7702_(corner.m_121945_(forward)) instanceof LaunchPadBlockEntity) {
            corner = corner.m_121945_(forward);
        }
        while (level.m_7702_(corner.m_121945_(right)) instanceof LaunchPadBlockEntity) {
            corner = corner.m_121945_(right);
        }
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (level.m_7702_(corner.m_5484_(forward, -x).m_5484_(right, -z)) instanceof LaunchPadBlockEntity) continue;
                return null;
            }
        }
        return corner;
    }

    public static ControlPanelBlockEntity findControlPanelFromLaunchPad(Level level, BlockPos pos) {
        BlockPos corner = MultiblockHelper.findCornerFromLaunchPad(level, pos);
        if (corner == null) {
            return null;
        }
        BlockEntity blockEntity = MultiblockHelper.findEdgeBlock(corner, Direction.NORTH.m_122424_(), level, (BlockEntityType)BlockEntities.CONTROL_PANEL.get());
        if (blockEntity != null) {
            return (ControlPanelBlockEntity)blockEntity;
        }
        return null;
    }
}

