/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.navigationpanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.woukie.createmissiles.MultiblockHelper;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlock;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlockEntity;
import net.woukie.createmissiles.block.entity.AbstractBasicBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelInstanceTracker;
import net.woukie.createmissiles.block.navigationpanel.messages.UpdateMapDataMessage;
import net.woukie.createmissiles.inventory.NavigationPanelMenu;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.registry.BlockEntities;
import net.woukie.createmissiles.registry.Packets;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class NavigationPanelBlockEntity
extends AbstractBasicBlockEntity {
    public static final int SLOT_MAP = 0;
    private double mapCrosshairX;
    private double mapCrosshairZ;
    private float thrustDurationPercent;
    private boolean initialized;
    private BlockPos target;
    private final ContainerData dataAccess;
    private Trajectory simulatedTrajectory;

    public NavigationPanelBlockEntity(BlockEntityType<?> blockEntityType, final BlockPos blockPos, final BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        this.mapCrosshairX = 64.0;
        this.mapCrosshairZ = 64.0;
        this.thrustDurationPercent = 0.5f;
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                return switch (i) {
                    case 0 -> (int)NavigationPanelBlockEntity.this.mapCrosshairX;
                    case 1 -> (int)NavigationPanelBlockEntity.this.mapCrosshairZ;
                    case 2 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 3 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.m_123341_();
                    }
                    case 4 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.m_123342_();
                    }
                    case 5 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.m_123343_();
                    }
                    case 6 -> NavigationPanelBlockEntity.this.m_58899_().m_123341_();
                    case 7 -> NavigationPanelBlockEntity.this.m_58899_().m_123342_();
                    case 8 -> NavigationPanelBlockEntity.this.m_58899_().m_123343_();
                    case 9 -> Float.floatToIntBits(NavigationPanelBlockEntity.this.thrustDurationPercent) >> 16;
                    case 10 -> Float.floatToIntBits(NavigationPanelBlockEntity.this.thrustDurationPercent) & 0xFFFF;
                    case 11 -> {
                        if (MultiblockHelper.findCorner(blockPos, ((Direction)blockState.m_61143_((Property)AssemblyPanelBlock.f_54117_)).m_122424_(), NavigationPanelBlockEntity.this.f_58857_) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 12 -> {
                        if (MultiblockHelper.findEdgeBlock((BlockEntity)NavigationPanelBlockEntity.this, NavigationPanelBlockEntity.this.m_58904_(), (BlockEntityType)BlockEntities.ASSEMBLY_PANEL.get()) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 13 -> {
                        Trajectory var3_2 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_2 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_2;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getUpperLaunchAngle().doubleValue()) >> 16;
                        }
                        yield 90;
                    }
                    case 14 -> {
                        Trajectory var3_3 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_3 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_3;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getUpperLaunchAngle().doubleValue()) & 0xFFFF;
                        }
                        yield 90;
                    }
                    case 15 -> {
                        Trajectory var3_4 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_4 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_4;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getLowerLaunchAngle().doubleValue()) >> 16;
                        }
                        yield 0;
                    }
                    case 16 -> {
                        Trajectory var3_5 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_5 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_5;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getLowerLaunchAngle().doubleValue()) & 0xFFFF;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int i, int j) {
            }

            public int m_6499_() {
                return 17;
            }
        };
    }

    public void serverTick() {
        if (!this.initialized && this.m_58898_()) {
            this.initialized = true;
            NavigationPanelInstanceTracker.add(this);
        }
        this.tickTarget();
        this.tickTrajectory();
    }

    public void fuelClicked(float fuelPercent) {
        this.thrustDurationPercent = fuelPercent;
        this.simulatedTrajectory = null;
    }

    public void mapClicked(double mapCrosshairX, double mapCrosshairZ) {
        this.mapCrosshairX = mapCrosshairX;
        this.mapCrosshairZ = mapCrosshairZ;
        this.target = null;
        this.simulatedTrajectory = null;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    private void tickTarget() {
        int scan;
        ItemStack mapItem = this.m_8020_(0);
        if (!mapItem.m_150930_(Items.f_42573_) || this.f_58857_ == null) {
            this.target = null;
            this.simulatedTrajectory = null;
            return;
        }
        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)mapItem, (Level)this.f_58857_);
        if (mapData == null) {
            this.target = null;
            this.simulatedTrajectory = null;
            return;
        }
        int multiplier = 1 << mapData.f_77890_;
        int blockX = (int)((double)(mapData.f_256718_ - 64 * multiplier) + (double)multiplier * this.mapCrosshairX);
        int blockZ = (int)((double)(mapData.f_256789_ - 64 * multiplier) + (double)multiplier * this.mapCrosshairZ);
        ChunkPos chunkPos = new ChunkPos(new BlockPos(blockX, 0, blockZ));
        if (!this.f_58857_.m_46749_(new BlockPos(blockX, 0, blockZ))) {
            ((ServerLevel)this.f_58857_).m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
            return;
        }
        BlockPos impactPos = new BlockPos(blockX, scan, blockZ);
        for (scan = this.f_58857_.m_151558_(); scan >= this.f_58857_.m_141937_() && this.f_58857_.m_8055_(impactPos = new BlockPos(blockX, scan, blockZ)).m_60795_(); --scan) {
        }
        this.target = impactPos;
        ((ServerLevel)this.f_58857_).m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
    }

    private void tickTrajectory() {
        Object chassisType;
        if (this.target == null) {
            return;
        }
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)AssemblyPanelBlock.f_54117_)).m_122424_();
        BlockPos corner = MultiblockHelper.findCorner(this.m_58899_(), facing, this.f_58857_);
        BlockEntity blockEntity = MultiblockHelper.findEdgeBlock(corner, facing, this.m_58904_(), (BlockEntityType)BlockEntities.ASSEMBLY_PANEL.get());
        if (blockEntity == null) {
            return;
        }
        AssemblyPanelBlockEntity assemblyPanel = (AssemblyPanelBlockEntity)blockEntity;
        if (!assemblyPanel.hasAllAssemblies()) {
            return;
        }
        if (this.simulatedTrajectory == null) {
            WarheadType warheadType = (WarheadType)PartTypes.get(assemblyPanel.m_8020_(0));
            chassisType = (ChassisType)PartTypes.get(assemblyPanel.m_8020_(1));
            ThrusterType thrusterType = (ThrusterType)PartTypes.get(assemblyPanel.m_8020_(2));
            Vector3d start = new Vector3d((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()).add(0.5, 0.5, 0.5);
            Vector3d end = new Vector3d((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_()).add(0.5, 0.5, 0.5);
            this.simulatedTrajectory = thrusterType.createTrajectory(this.f_58857_, start, end, warheadType, (ChassisType)chassisType, thrusterType, null, this);
        }
        if ((chassisType = this.simulatedTrajectory) instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)chassisType;
            Double low = ballisticTrajectory.getLowerDistanceToTarget();
            Double up = ballisticTrajectory.getUpperDistanceToTarget();
            if (low == null || up == null || low + up > 0.5) {
                ballisticTrajectory.refineLaunchAngleOnce();
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        NavigationPanelInstanceTracker.remove(this);
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)this.items);
        this.mapCrosshairX = compoundTag.m_128459_("MapCrosshairX");
        this.mapCrosshairZ = compoundTag.m_128459_("MapCrosshairZ");
        this.thrustDurationPercent = compoundTag.m_128457_("FuelPercent");
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128347_("MapCrosshairX", this.mapCrosshairX);
        compoundTag.m_128347_("MapCrosshairZ", this.mapCrosshairZ);
        compoundTag.m_128350_("FuelPercent", this.thrustDurationPercent);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)this.items);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.createmissiles.navigation_panel");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory playerInventory) {
        ItemStack itemStack;
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)AssemblyPanelBlock.f_54117_)).m_122424_();
        BlockPos corner = MultiblockHelper.findCorner(this.m_58899_(), facing, this.f_58857_);
        BlockEntity assemblyPanel = MultiblockHelper.findEdgeBlock(corner, facing, this.m_58904_(), (BlockEntityType)BlockEntities.ASSEMBLY_PANEL.get());
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (itemStack = this.m_8020_(0)).m_150930_(Items.f_42573_) && !itemStack.m_41619_()) {
            MapItemSavedData data = MapItem.m_42853_((ItemStack)itemStack, (Level)this.f_58857_);
            Integer mapId = MapItem.m_151131_((ItemStack)itemStack);
            if (data != null && mapId != null) {
                Packets.UPDATE_MAP_DATA.sendToPlayer((ServerPlayer)playerInventory.f_35978_, (Object)new UpdateMapDataMessage(mapId, data.m_7176_(new CompoundTag())));
            }
        }
        return new NavigationPanelMenu(id, playerInventory, (Container)this, this.dataAccess, (Container)(assemblyPanel == null ? new SimpleContainer(3) : (AssemblyPanelBlockEntity)assemblyPanel));
    }

    public boolean m_7013_(int i, @NotNull ItemStack itemStack) {
        return i == 0 && itemStack.m_150930_(Items.f_42573_);
    }

    public double getUpperLaunchAngle() {
        Trajectory trajectory = this.simulatedTrajectory;
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            return ballisticTrajectory.getUpperLaunchAngle();
        }
        return 0.0;
    }

    public double getLowerLaunchAngle() {
        Trajectory trajectory = this.simulatedTrajectory;
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            return ballisticTrajectory.getLowerLaunchAngle();
        }
        return 0.0;
    }

    public float getThrustDurationPercent() {
        return this.thrustDurationPercent;
    }
}

