/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.navigationpanel.messages;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelInstanceTracker;

public class ClickMapMessage {
    public final BlockPos source;
    public final double mapCrosshairX;
    public final double mapCrosshairZ;

    public ClickMapMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readDouble(), buf.readDouble());
    }

    public ClickMapMessage(BlockPos source, double mapCrosshairX, double mapCrosshairZ) {
        this.source = source;
        this.mapCrosshairX = mapCrosshairX;
        this.mapCrosshairZ = mapCrosshairZ;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.source);
        buf.writeDouble(this.mapCrosshairX);
        buf.writeDouble(this.mapCrosshairZ);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        Player player = contextSupplier.get().getPlayer();
        if (player == null) {
            return;
        }
        NavigationPanelBlockEntity blockEntity = NavigationPanelInstanceTracker.get(player.m_9236_(), this.source);
        if (blockEntity == null) {
            return;
        }
        if (this.mapCrosshairX >= 0.0 && this.mapCrosshairZ >= 0.0 && this.mapCrosshairX <= 128.0 && this.mapCrosshairZ <= 128.0) {
            blockEntity.mapClicked(this.mapCrosshairX, this.mapCrosshairZ);
        }
    }
}

