/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Rotations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.woukie.createmissiles.client.MissilePartModel;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.PartModels;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MissileRenderer
extends EntityRenderer<MissileEntity> {
    public MissileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull MissileEntity entity, float f, float g, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i) {
        WarheadType warheadType = (WarheadType)PartTypes.get(entity.getWarheadType());
        ChassisType chassisType = (ChassisType)PartTypes.get(entity.getChassisType());
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(entity.getThrusterType());
        poseStack.m_85836_();
        Vector3f offset = new Vector3f(0.0f, 4.0f, 0.0f);
        if (thrusterType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(thrusterType.getResourceLocation()), entity.getThrusterBuildPercent(), offset);
        }
        if (chassisType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(chassisType.getResourceLocation()), entity.getChassisBuildPercent(), offset);
        }
        if (warheadType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(warheadType.getResourceLocation()), entity.getWarheadBuildPercent(), offset);
        }
        super.m_7392_((Entity)entity, f, g, poseStack, multiBufferSource, i);
        poseStack.m_85849_();
    }

    private static void renderPart(@NotNull MissileEntity entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, MissilePartModel model, int buildPercent, Vector3f offset) {
        int stage = model.getStage(buildPercent);
        Map<String, Vector3f> attachments = model.getAttachements(stage);
        offset.add((Vector3fc)attachments.get("bottom"));
        LayerDefinition warheadModelLayerDefinition = model.getLayerDefinition(stage);
        ModelPart part = warheadModelLayerDefinition.m_171564_();
        Rotations rotation = entity.getRotation();
        part.m_252899_(new Vector3f(rotation.m_123156_(), rotation.m_123157_(), rotation.m_123158_()));
        Vector3f vec = new Vector3f((Vector3fc)offset);
        part.m_252854_(vec.rotateX(rotation.m_123156_()).rotateY(rotation.m_123157_()).rotateZ(rotation.m_123158_()));
        VertexConsumer warheadVertexConsumer = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)model.getTexture(stage)));
        part.m_104306_(poseStack, warheadVertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (attachments.containsKey("top")) {
            offset.add((Vector3fc)attachments.get("top"));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MissileEntity entity) {
        return new ResourceLocation("createmissiles", "textures/entity/gunpowder_thruster.png");
    }
}

