/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.woukie.createmissiles.inventory.DroneMenu;
import net.woukie.createmissiles.registry.Items;
import org.jetbrains.annotations.NotNull;

public class DroneScreen
extends AbstractContainerScreen<DroneMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("createmissiles", "textures/gui/container/drone_panel.png");
    private static final ResourceLocation LAUNCH_BUTTON = new ResourceLocation("createmissiles", "textures/gui/sprites/container/launch_drone_button.png");
    private static final ResourceLocation LAUNCH_BUTTON_HOVER = new ResourceLocation("createmissiles", "textures/gui/sprites/container/launch_drone_button_hover.png");
    private EditBox tbXPos;
    private EditBox tbYPos;
    private boolean sendClickable;
    private boolean initialised;
    private int sendButtonLeft = 151;
    private int sendButtonTop = 53;
    private int sendButtonWidth = 18;
    private int sendButtonHeight = 18;
    private final ItemStack droneStack = new ItemStack((ItemLike)Items.DRONE_BOX_ITEM.get());
    private final ItemStack reinforcedDroneStack = new ItemStack((ItemLike)Items.REINFORCED_DRONE_BOX.get());

    public DroneScreen(DroneMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tbXPos = new EditBox(this.f_96547_, this.f_97735_ + 80, this.f_97736_ + 16, 88, 14, (Component)Component.m_237113_((String)"X-Pos"));
        this.tbXPos.m_94153_(DroneScreen.integerFilter());
        this.tbXPos.m_94199_(50);
        this.tbXPos.m_93692_(false);
        this.m_142416_((GuiEventListener)this.tbXPos);
        this.tbYPos = new EditBox(this.f_96547_, this.f_97735_ + 80, this.f_97736_ + 35, 88, 14, (Component)Component.m_237113_((String)"Y-Pos"));
        this.tbYPos.m_94153_(DroneScreen.integerFilter());
        this.tbYPos.m_94199_(50);
        this.tbYPos.m_93692_(false);
        this.m_142416_((GuiEventListener)this.tbYPos);
    }

    @NotNull
    private static Predicate<String> integerFilter() {
        return s -> {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (i == 0 && chars[i] == '-') continue;
                try {
                    Integer.parseInt("" + chars[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        };
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        this.m_280072_(guiGraphics, i, j);
        this.renderDroneBox(guiGraphics);
        this.tbXPos.m_88315_(guiGraphics, i, j, f);
        this.tbYPos.m_88315_(guiGraphics, i, j, f);
        if (!this.initialised) {
            this.tbXPos.m_94164_("" + ((DroneMenu)this.m_6262_()).getInitialX());
            this.tbYPos.m_94164_("" + ((DroneMenu)this.m_6262_()).getInitialZ());
            this.initialised = true;
        }
        try {
            Integer.parseInt(this.tbXPos.m_94155_());
            Integer.parseInt(this.tbYPos.m_94155_());
            this.sendClickable = true;
        }
        catch (NumberFormatException e) {
            this.sendClickable = false;
        }
        if (this.sendClickable && !((DroneMenu)this.m_6262_()).hasEmptyMap()) {
            this.sendClickable = false;
        }
        this.renderButton(guiGraphics, i, j, f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        guiGraphics.m_280554_(this.f_96547_, FormattedText.m_130762_((String)"X", (Style)Style.f_131099_.m_178520_(0xFFFFFF)), 68, 20, 12, 16);
        guiGraphics.m_280554_(this.f_96547_, FormattedText.m_130762_((String)"Z", (Style)Style.f_131099_.m_178520_(0xFFFFFF)), 68, 39, 12, 16);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double d, double e, int i) {
        this.tbXPos.m_94186_(this.tbXPos.m_5953_(d, e));
        this.tbXPos.m_93692_(this.tbXPos.m_5953_(d, e));
        this.tbYPos.m_94186_(this.tbYPos.m_5953_(d, e));
        this.tbYPos.m_93692_(this.tbYPos.m_5953_(d, e));
        if (this.sendClickable && this.m_6774_(this.sendButtonLeft, this.sendButtonTop, this.sendButtonWidth, this.sendButtonHeight, d, e)) {
            ((DroneMenu)this.m_6262_()).clickLaunch(new BlockPos(Integer.parseInt(this.tbXPos.m_94155_()), 0, Integer.parseInt(this.tbYPos.m_94155_())));
        }
        return super.m_6375_(d, e, i);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float f, int i, int j) {
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.tbXPos.m_93696_() && (this.tbXPos.m_7933_(keyCode, scanCode, modifiers) || this.tbXPos.m_94204_())) {
            return true;
        }
        if (this.tbYPos.m_93696_() && (this.tbYPos.m_7933_(keyCode, scanCode, modifiers) || this.tbYPos.m_94204_())) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.tbXPos.m_93696_()) {
            return this.tbXPos.m_5534_(codePoint, modifiers);
        }
        if (this.tbYPos.m_93696_()) {
            return this.tbYPos.m_5534_(codePoint, modifiers);
        }
        return false;
    }

    private void renderDroneBox(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float x = this.f_97735_ + 8 + 27;
        float y = this.f_97736_ + 16 + 27;
        poseStack.m_252880_(x, y, 0.0f);
        float scale = 3.0f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-8.0f, -8.0f, 0.0f);
        guiGraphics.m_280480_(((DroneMenu)this.m_6262_()).isBasic() ? this.droneStack : this.reinforcedDroneStack, 0, 0);
        poseStack.m_85849_();
    }

    private void renderButton(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.sendClickable) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
            ResourceLocation resource = this.m_6774_(this.sendButtonLeft, this.sendButtonTop, this.sendButtonWidth, this.sendButtonHeight, i, j) ? LAUNCH_BUTTON_HOVER : LAUNCH_BUTTON;
            guiGraphics.m_280163_(resource, this.sendButtonLeft, this.sendButtonTop, 0.0f, 0.0f, this.sendButtonWidth, this.sendButtonHeight, this.sendButtonWidth, this.sendButtonHeight);
            poseStack.m_85849_();
        }
    }
}

