/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client.screens;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.woukie.createmissiles.inventory.NavigationPanelMenu;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class NavigationPanelScreen
extends AbstractContainerScreen<NavigationPanelMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("createmissiles", "textures/gui/container/navigation_panel.png");
    private static final ResourceLocation MAP_ERROR = new ResourceLocation("createmissiles", "textures/gui/sprites/container/map_error.png");
    private static final ResourceLocation NO_MAP = new ResourceLocation("createmissiles", "textures/gui/sprites/container/no_map.png");
    private static final ResourceLocation MAP_TARGET_HORIZONTAL = new ResourceLocation("createmissiles", "textures/gui/sprites/container/target_horizontal.png");
    private static final ResourceLocation MAP_TARGET_VERTICAL = new ResourceLocation("createmissiles", "textures/gui/sprites/container/target_vertical.png");
    private static final ResourceLocation MAP_TARGET = new ResourceLocation("createmissiles", "textures/gui/sprites/container/target_marker.png");
    private static final ResourceLocation TRAJECTORY_NO_MAP = new ResourceLocation("createmissiles", "textures/gui/sprites/container/trajectory_no_map.png");
    private static final ResourceLocation TRAJECTORY_TARGET_LOADING = new ResourceLocation("createmissiles", "textures/gui/sprites/container/trajectory_target_loading.png");
    private static final ResourceLocation INVALID_SETUP = new ResourceLocation("createmissiles", "textures/gui/sprites/container/invalid_setup.png");
    private static final ResourceLocation FUEL = new ResourceLocation("createmissiles", "textures/gui/sprites/container/fuel.png");
    private static final ResourceLocation WHITE_DOT = new ResourceLocation("createmissiles", "textures/gui/sprites/container/white_dot.png");
    private static final ResourceLocation FUEL_GAUGE = new ResourceLocation("createmissiles", "textures/gui/sprites/container/fuel_gauge.png");
    private static final ResourceLocation MIN_THRUST_DURATION = new ResourceLocation("createmissiles", "textures/gui/sprites/container/min_thrust_duration.png");
    private static final int mapLeft = 8;
    private static final int mapTop = 16;
    private static final int mapWidth = 54;
    private static final int mapHeight = 54;
    private static final int fuelLeft = 106;
    private static final int fuelTop = 16;
    private static final int fuelWidth = 5;
    private static final int fuelHeight = 54;
    private static final int trajectoryLeft = 114;
    private static final int trajectoryTop = 16;
    private static final int trajectoryWidth = 53;
    private static final int trajectoryHeight = 53;
    private static final int trajectoryPadding = 2;
    private double currentMapCrosshairX = 0.0;
    private double currentMapCrosshairZ = 0.0;
    private double currentFuel1 = 0.0;
    private double currentFuel2 = 0.0;
    private double currentMinThrustDuration1 = 0.0;
    private double currentMinThrustDuration2 = 0.0;
    private double maxThrustDuration = 0.0;
    private double minThrustDuration = 0.0;
    private final List<Vector2d> positions = new ArrayList<Vector2d>();
    private double maxHeight = 256.0;
    private double lastFuelPercent = 0.0;
    private double distanceToTarget = 0.0;
    private BlockPos lastTargetPos = new BlockPos(0, 0, 0);
    private Float lastUpperLaunchAngle = null;
    private Float lastLowerLaunchAngle = null;

    public NavigationPanelScreen(NavigationPanelMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void m_88315_(@NotNull GuiGraphics gui, int i, int j, float f) {
        super.m_88315_(gui, i, j, f);
        this.m_280072_(gui, i, j);
        this.renderCrosshair(gui);
    }

    protected void m_7286_(GuiGraphics gui, float f, int i, int j) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, -1.0f);
        gui.m_280218_(BACKGROUND, 0, 0, 0, 0, this.f_97726_, this.f_97727_);
        this.simulateTrajectory();
        this.renderMap(gui);
        this.renderFuel(gui);
        this.renderTrajectory(gui);
        this.renderText(gui);
        gui.m_280168_().m_85849_();
    }

    public boolean m_6375_(double x, double z, int i) {
        if (this.m_6774_(8, 16, 54, 54, x, z)) {
            double mapCrosshairX = (x - (double)this.f_97735_ - 8.0) * 2.3703703703703702;
            double mapCrosshairZ = (z - (double)this.f_97736_ - 16.0) * 2.3703703703703702;
            ItemStack map = ((NavigationPanelMenu)this.m_6262_()).getMap();
            if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || map == null || MapItem.m_42853_((ItemStack)map, (Level)this.f_96541_.f_91073_) == null) {
                return super.m_6375_(x, z, i);
            }
            ((NavigationPanelMenu)this.m_6262_()).clickMap(mapCrosshairX, mapCrosshairZ);
        }
        if (this.m_6774_(106, 16, 5, 54, x, z)) {
            double fuelClickZ = z - (double)this.f_97736_ - 16.0;
            ((NavigationPanelMenu)this.m_6262_()).clickFuel((float)(1.0 - fuelClickZ / 54.0));
        }
        return super.m_6375_(x, z, i);
    }

    private void renderMap(GuiGraphics gui) {
        assert (this.f_96541_ != null && this.f_96541_.f_91073_ != null);
        ItemStack mapItem = ((NavigationPanelMenu)this.m_6262_()).getMap();
        if (mapItem == null) {
            gui.m_280398_(NO_MAP, 8, 16, 5, 0.0f, 0.0f, 54, 54, 54, 54);
            return;
        }
        Integer mapId = MapItem.m_151131_((ItemStack)mapItem);
        MapItemSavedData mapData = MapItem.m_151128_((Integer)mapId, (Level)this.f_96541_.f_91073_);
        if (mapId == null || mapData == null) {
            gui.m_280398_(MAP_ERROR, 8, 16, 5, 0.0f, 0.0f, 54, 54, 54, 54);
            return;
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(8.0f, 16.0f, 1.0f);
        gui.m_280168_().m_85841_(0.421875f, 0.421875f, 1.0f);
        this.f_96541_.f_91063_.m_109151_().m_168771_(gui.m_280168_(), (MultiBufferSource)gui.m_280091_(), mapId.intValue(), mapData, true, 0xF000F0);
        gui.m_280168_().m_85849_();
    }

    private void renderCrosshair(GuiGraphics gui) {
        int targetMapCrosshairX = ((NavigationPanelMenu)this.m_6262_()).getMapCrosshairX();
        int targetMapCrosshairZ = ((NavigationPanelMenu)this.m_6262_()).getMapCrosshairZ();
        this.currentMapCrosshairX += ((double)targetMapCrosshairX - this.currentMapCrosshairX) * (double)0.1f;
        this.currentMapCrosshairZ += ((double)targetMapCrosshairZ - this.currentMapCrosshairZ) * (double)0.1f;
        int scaledX = (int)(this.currentMapCrosshairX * 54.0 / 128.0);
        int scaledY = (int)(this.currentMapCrosshairZ * 54.0 / 128.0);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_((float)(8 + this.f_97735_), (float)(16 + this.f_97736_), 10.0f);
        int scissorLeft = this.f_97735_ + 8;
        int scissorTop = this.f_97736_ + 16;
        gui.m_280588_(scissorLeft - 1, scissorTop - 1, scissorLeft + 54 + 1, scissorTop + 54 + 1);
        gui.m_280398_(MAP_TARGET, scaledX - 4, scaledY - 4, 2, 0.0f, 0.0f, 9, 9, 9, 9);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        gui.m_280398_(MAP_TARGET_VERTICAL, scaledX - 2, -4, 1, 0.0f, 0.0f, 5, 62, 5, 62);
        gui.m_280398_(MAP_TARGET_HORIZONTAL, -4, scaledY - 2, 1, 0.0f, 0.0f, 62, 5, 62, 5);
        gui.m_280168_().m_85849_();
        gui.m_280618_();
        gui.m_280168_().m_85849_();
    }

    private void renderTrajectory(GuiGraphics gui) {
        assert (this.f_96541_ != null);
        if (!((NavigationPanelMenu)this.m_6262_()).launchPadExists() || ((NavigationPanelMenu)this.m_6262_()).assemblyPanelAbsent()) {
            gui.m_280398_(INVALID_SETUP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        ItemStack mapItem = ((NavigationPanelMenu)this.m_6262_()).getMap();
        if (mapItem == null) {
            gui.m_280398_(TRAJECTORY_NO_MAP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        BlockPos source = ((NavigationPanelMenu)this.m_6262_()).getSource();
        BlockPos target = ((NavigationPanelMenu)this.m_6262_()).getTarget();
        if (source == null || target == null) {
            gui.m_280398_(TRAJECTORY_TARGET_LOADING, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        ItemStack warhead = ((NavigationPanelMenu)this.m_6262_()).getWarhead();
        ItemStack chassis = ((NavigationPanelMenu)this.m_6262_()).getChassis();
        ItemStack thruster = ((NavigationPanelMenu)this.m_6262_()).getThruster();
        if (warhead == null || chassis == null || thruster == null) {
            gui.m_280398_(INVALID_SETUP, 114, 16, 5, 0.0f, 0.0f, 53, 53, 53, 53);
            return;
        }
        if (this.positions.isEmpty()) {
            return;
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(116.0f, 18.0f, 0.0f);
        double yBottom = Math.min(target.m_123342_(), source.m_123342_());
        double yTop = this.maxHeight;
        double xStart = 0.0;
        double xEnd = Vector3d.distance((double)target.m_123341_(), (double)0.0, (double)target.m_123343_(), (double)source.m_123341_(), (double)0.0, (double)source.m_123343_());
        int width = 49;
        int height = 49;
        int xLine = Math.max((int)this.mapRange(source.m_123342_(), yBottom, yTop, 0.0, height), 0);
        if (xLine < height) {
            gui.m_280656_(0, width, height - xLine, 0x77FFFFFF);
        }
        gui.m_280315_(0, 0, height, 0x77FFFFFF);
        Vector2i lastPixelPos = null;
        for (int i = 0; i < width; ++i) {
            Vector2d currentPos = this.positions.get(i * this.positions.size() / width);
            Vector2i currentPixelPos = new Vector2i((int)this.mapRange(currentPos.x, xStart, xEnd, 0.0, width), (int)this.mapRange(currentPos.y, yBottom, yTop, 0.0, height));
            if (lastPixelPos != null) {
                this.traverseLine(currentPixelPos, lastPixelPos, interpPos -> {
                    Vector2i p = new Vector2i((int)interpPos.x, (int)interpPos.y);
                    if (p.y < 0 || p.y > height || p.x < 0 || p.x > width) {
                        return;
                    }
                    gui.m_280656_(p.x, p.x, height - p.y, -1);
                });
            }
            lastPixelPos = currentPixelPos;
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        float redness = -((float)Math.pow(-(this.distanceToTarget / 10.0 + 1.0), -1.0));
        int colour = FastColor.ARGB32.m_269105_((float)redness, (int)0xFF0000, (int)0xFFFFFF);
        gui.m_280488_(this.f_96547_, new DecimalFormat("#0.00").format(this.distanceToTarget) + "m", 0, 0, colour);
        gui.m_280168_().m_85849_();
        gui.m_280168_().m_85849_();
    }

    private void renderText(GuiGraphics gui) {
        gui.m_280168_().m_85836_();
        float scale = 0.5f;
        gui.m_280168_().m_85841_(scale, scale, scale);
        String textTime = Double.toString(this.maxThrustDuration);
        int paddingX = 3;
        gui.m_280056_(this.f_96547_, textTime, (int)((float)(106 - this.f_96547_.m_92895_(textTime) - paddingX) / scale), (int)(14.0f / scale), 0, false);
        String textDeltaT = "\u0394t";
        gui.m_280056_(this.f_96547_, textDeltaT, (int)((float)(106 - this.f_96547_.m_92895_(textDeltaT) - paddingX) / scale), (int)(68.0f / scale), 0, false);
        gui.m_280168_().m_85849_();
    }

    private void renderFuel(GuiGraphics gui) {
        this.currentFuel1 += (((NavigationPanelMenu)this.m_6262_()).getFuelPercent() - this.currentFuel2) * 0.1;
        this.currentFuel2 += (this.currentFuel1 - this.currentFuel2) * 0.1;
        int barHeight = 54 - (int)(this.currentFuel2 * 54.0);
        barHeight = Math.min(Math.max(barHeight, 1), 54);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(106.0f, 16.0f, 0.0f);
        gui.m_280398_(FUEL, 0, barHeight, 0, 0.0f, (float)barHeight, 5, 54 - barHeight, 5, barHeight);
        gui.m_280398_(FUEL_GAUGE, -2, barHeight - 3, 1, 0.0f, 0.0f, 9, 5, 9, 5);
        gui.m_280168_().m_85849_();
    }

    private void simulateTrajectory() {
        BlockPos target = ((NavigationPanelMenu)this.m_6262_()).getTarget();
        if (target == null) {
            this.distanceToTarget = 0.0;
            this.positions.clear();
            return;
        }
        if (target.equals((Object)this.lastTargetPos) && this.lastFuelPercent == ((NavigationPanelMenu)this.m_6262_()).getFuelPercent() && this.lastUpperLaunchAngle.floatValue() == ((NavigationPanelMenu)this.m_6262_()).getUpperLaunchAngle() && this.lastLowerLaunchAngle.floatValue() == ((NavigationPanelMenu)this.m_6262_()).getLowerLaunchAngle()) {
            return;
        }
        this.lastTargetPos = ((NavigationPanelMenu)this.m_6262_()).getTarget();
        this.lastFuelPercent = ((NavigationPanelMenu)this.m_6262_()).getFuelPercent();
        this.lastUpperLaunchAngle = Float.valueOf(((NavigationPanelMenu)this.m_6262_()).getUpperLaunchAngle());
        this.lastLowerLaunchAngle = Float.valueOf(((NavigationPanelMenu)this.m_6262_()).getLowerLaunchAngle());
        WarheadType warheadType = (WarheadType)PartTypes.get(((NavigationPanelMenu)this.m_6262_()).getWarhead());
        ChassisType chassisType = (ChassisType)PartTypes.get(((NavigationPanelMenu)this.m_6262_()).getChassis());
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(((NavigationPanelMenu)this.m_6262_()).getThruster());
        if (warheadType == null || chassisType == null || thrusterType == null) {
            return;
        }
        this.maxThrustDuration = chassisType.getFuelCapacity() / thrusterType.getBurnRate();
        BlockPos source = ((NavigationPanelMenu)this.m_6262_()).getSource();
        Vector3d start = new Vector3d((double)source.m_123341_(), (double)source.m_123342_(), (double)source.m_123343_()).add(0.5, 0.5, 0.5);
        Vector3d end = new Vector3d((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_()).add(0.5, 0.5, 0.5);
        float launchAngle = (((NavigationPanelMenu)this.m_6262_()).getLowerLaunchAngle() + ((NavigationPanelMenu)this.m_6262_()).getUpperLaunchAngle()) / 2.0f;
        this.positions.clear();
        BallisticTrajectory simulatedTrajectory = new BallisticTrajectory(new Vector3d((Vector3dc)start), new Vector3d((Vector3dc)end), warheadType, chassisType, thrusterType, launchAngle, ((NavigationPanelMenu)this.m_6262_()).getFuelPercent());
        double minDistance = Double.POSITIVE_INFINITY;
        double previousDistance = Double.POSITIVE_INFINITY;
        while (true) {
            boolean descending;
            Vector3d currentPosition = new Vector3d((Vector3dc)simulatedTrajectory.getPosition());
            if (Double.isNaN(currentPosition.x)) break;
            Vector2d currentPosition2D = new Vector2d(new Vector2d(currentPosition.x, currentPosition.z).distance((Vector2dc)new Vector2d(start.x, start.z)), currentPosition.y);
            this.positions.add(currentPosition2D);
            double currentDistance = end.distance((Vector3dc)currentPosition);
            minDistance = Math.min(minDistance, currentDistance);
            boolean bl = descending = simulatedTrajectory.getVelocity().y < 0.0;
            if (descending && currentDistance > previousDistance) break;
            previousDistance = currentDistance;
            simulatedTrajectory.tick();
        }
        this.distanceToTarget = minDistance;
        BallisticTrajectory maxFuelSimulatedTrajectory = new BallisticTrajectory(new Vector3d((Vector3dc)start), new Vector3d((Vector3dc)end), warheadType, chassisType, thrusterType, launchAngle, 1.0);
        while (!(maxFuelSimulatedTrajectory.getVelocity().y < 0.0)) {
            this.maxHeight = maxFuelSimulatedTrajectory.getPosition().y;
            if (Double.isNaN(this.maxHeight)) break;
            maxFuelSimulatedTrajectory.tick();
        }
    }

    private void traverseLine(Vector2i startI, Vector2i endI, Consumer<Vector2d> callback) {
        Vector2d start = new Vector2d((double)startI.x, (double)startI.y);
        Vector2d end = new Vector2d((double)endI.x, (double)endI.y);
        Vector2d currentPos = new Vector2d((Vector2dc)start);
        Vector2d increment = new Vector2d((Vector2dc)end).sub((Vector2dc)start).normalize();
        double distanceSqr = currentPos.distanceSquared((Vector2dc)end);
        while (currentPos.distanceSquared((Vector2dc)start) < distanceSqr) {
            callback.accept(new Vector2d((Vector2dc)currentPos));
            currentPos.add((Vector2dc)increment);
        }
    }

    private double mapRange(double value, double oldMin, double oldMax, double newMin, double nawMax) {
        return newMin + (value - oldMin) * (nawMax - newMin) / (oldMax - oldMin);
    }
}

