/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.block.FlamingFireBlock;
import net.woukie.createmissiles.entity.BallEntity;
import org.jetbrains.annotations.NotNull;

public class FlamingballEntity
extends BallEntity {
    boolean spent;

    public FlamingballEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        if (this.m_9236_().m_7654_() == null || this.spent) {
            return;
        }
        super.m_6532_(hitResult);
        BlockPos spawnPos = Util.locateNearestMatchingBlock(hitResult.m_82450_(), blockPos -> this.m_9236_().m_8055_(blockPos).m_60722_((Fluid)Fluids.f_76193_), 20);
        spawnPos = spawnPos == null ? BlockPos.m_274446_((Position)hitResult.m_82450_()) : spawnPos;
        this.explode(spawnPos);
    }

    protected void explode(BlockPos position) {
        this.spreadFire(5, 3, position, (ServerLevel)this.m_9236_());
        this.spent = true;
        this.m_146870_();
    }

    private void spreadFire(int radius, int height, BlockPos position, ServerLevel level) {
        for (int x = -radius; x < radius; ++x) {
            block1: for (int z = -radius; z < radius; ++z) {
                double chance = 1.0 - Math.sqrt(x * x + z * z) / (double)radius;
                if (Math.random() > chance) continue;
                BlockPos selectedBlock = position.m_5484_(Direction.NORTH, x).m_5484_(Direction.EAST, z);
                boolean previouslySolid = false;
                for (int y = -height; y < height; ++y) {
                    BlockPos testBlockPos = selectedBlock.m_5484_(Direction.UP, y);
                    if (level.m_46859_(testBlockPos)) {
                        if (!previouslySolid) continue;
                        if (Math.random() > 0.5) {
                            level.m_7731_(testBlockPos, ((FlamingFireBlock)((Object)net.woukie.createmissiles.registry.Blocks.FLAMING_FIRE.get())).m_49966_(), 3);
                            continue block1;
                        }
                        level.m_7731_(testBlockPos, Blocks.f_50083_.m_49966_(), 3);
                        continue block1;
                    }
                    previouslySolid = true;
                }
            }
        }
    }

    @NotNull
    public ItemStack m_7846_() {
        return Items.f_42593_.m_7968_();
    }
}

