/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.entity.drone.Drone;
import org.jetbrains.annotations.NotNull;

public class DroneHandler
extends SavedData {
    private static WorldAttached<HashMap<UUID, CompoundTag>> drones = new WorldAttached<HashMap<UUID, CompoundTag>>(l -> new HashMap()){};
    private static HashMap<UUID, Entity> entityCache = new HashMap();
    private static Set<UUID> killEntityWhenever = new HashSet<UUID>();
    private static Set<UUID> stopTrackingNextTick = new HashSet<UUID>();
    private static MinecraftServer server;
    private static DroneHandler instance;
    private static boolean initialized;
    private static boolean destroyOnSave;

    private DroneHandler() {
    }

    public static DroneHandler get() {
        if (instance == null) {
            instance = new DroneHandler();
        }
        return instance;
    }

    public void trackDrone(Drone drone) {
        ((HashMap)drones.get((LevelAccessor)drone.m_9236_())).put(drone.m_20148_(), drone.m_20240_(new CompoundTag()));
        this.m_77762_();
    }

    public void stopTrackingDrone(ServerLevel level, UUID uuid) {
        ((HashMap)drones.get((LevelAccessor)level)).remove(uuid);
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.m_77762_();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        server.m_129785_().forEach(serverLevel -> {
            killEntityWhenever.removeIf(uuid -> {
                Entity e = serverLevel.m_8791_(uuid);
                if (e != null) {
                    e.m_146870_();
                    entityCache.remove(e.m_20148_());
                    return true;
                }
                return false;
            });
            stopTrackingNextTick.forEach(uuid -> this.stopTrackingDrone((ServerLevel)serverLevel, (UUID)uuid));
            ArrayList changedUUID = new ArrayList();
            ((HashMap)drones.get((LevelAccessor)serverLevel)).forEach((uuid, tag) -> {
                if (this.tickDrone((ServerLevel)serverLevel, (UUID)uuid, (CompoundTag)tag)) {
                    changedUUID.add(uuid);
                }
            });
            changedUUID.forEach(uuid -> {
                HashMap levelData = (HashMap)drones.get((LevelAccessor)serverLevel);
                CompoundTag data = (CompoundTag)levelData.get(uuid);
                levelData.remove(uuid);
                levelData.put(data.m_128342_("UUID"), data);
            });
        });
    }

    private boolean tickDrone(ServerLevel level, UUID uuid, CompoundTag drone) {
        boolean ticking;
        Entity entity = entityCache.computeIfAbsent(uuid, uuid1 -> level.m_8791_(uuid));
        boolean entityLoaded = entity != null;
        boolean bl = ticking = entityLoaded && level.m_143340_(entity.m_20183_());
        if (ticking) {
            CompoundTag updatedData = entity.m_20240_(new CompoundTag());
            updatedData.m_128379_("Simulated", false);
            updatedData.m_128359_("id", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
            ((HashMap)drones.get((LevelAccessor)level)).put(uuid, updatedData);
            return false;
        }
        if (entityLoaded || !drone.m_128441_("Simulated") || !drone.m_128471_("Simulated")) {
            killEntityWhenever.add(drone.m_128342_("UUID"));
            entityCache.remove(uuid);
            drone.m_128362_("UUID", UUID.randomUUID());
            drone.m_128379_("Simulated", true);
            return true;
        }
        DroneHandler.simulateDroneMovement(drone);
        if (DroneHandler.shouldBeReal(level, drone)) {
            DroneHandler.makeReal(level, drone);
        }
        return false;
    }

    private static boolean shouldBeReal(ServerLevel level, CompoundTag drone) {
        ListTag posList = drone.m_128437_("Pos", 6);
        BlockPos currentBlockPosition = BlockPos.m_274446_((Position)new Vec3(posList.m_128772_(0), posList.m_128772_(1), posList.m_128772_(2)));
        return drone.m_128441_("Simulated") && drone.m_128471_("Simulated") && level.m_46749_(currentBlockPosition) && level.m_143340_(currentBlockPosition);
    }

    private static void makeReal(ServerLevel level, CompoundTag drone) {
        ListTag posList = drone.m_128437_("Pos", 6);
        Vec3 currentPosition = new Vec3(posList.m_128772_(0), posList.m_128772_(1), posList.m_128772_(2));
        BlockPos target = null;
        if (drone.m_128441_("TargetBlockX")) {
            target = new BlockPos(drone.m_128451_("TargetBlockX"), drone.m_128451_("TargetBlockY"), drone.m_128451_("TargetBlockZ"));
        } else if (drone.m_128441_("OriginBlockX")) {
            target = new BlockPos(drone.m_128451_("OriginBlockX"), drone.m_128451_("OriginBlockY"), drone.m_128451_("OriginBlockZ"));
        }
        EntityType entityType = (EntityType)EntityType.m_20637_((CompoundTag)drone).get();
        Entity entity = entityType.m_20615_((Level)level);
        entity.m_20258_(drone);
        entity.m_20084_(drone.m_128342_("UUID"));
        if (target != null) {
            double dX = (double)target.m_123341_() - currentPosition.f_82479_;
            double dZ = (double)target.m_123343_() - currentPosition.f_82481_;
            float angle = (float)Mth.m_14136_((double)dZ, (double)dX);
            float targetYRot = Mth.m_14177_((float)(angle * 57.295776f));
            entity.m_146922_(targetYRot - 90.0f);
            entity.m_5618_(entity.m_146908_());
        }
        level.m_7967_(entity);
        entityCache.put(drone.m_128342_("UUID"), entity);
        entity.m_146884_(DroneHandler.getAdjustedLoadPosition(level, currentPosition));
    }

    private static void simulateDroneMovement(CompoundTag drone) {
        BlockPos currentTarget;
        BlockPos originBlock = null;
        BlockPos targetBlock = null;
        if (drone.m_128441_("OriginBlockX")) {
            originBlock = new BlockPos(drone.m_128451_("OriginBlockX"), drone.m_128451_("OriginBlockY"), drone.m_128451_("OriginBlockZ"));
        }
        if (drone.m_128441_("TargetBlockX")) {
            targetBlock = new BlockPos(drone.m_128451_("TargetBlockX"), drone.m_128451_("TargetBlockY"), drone.m_128451_("TargetBlockZ"));
        }
        ListTag posList = drone.m_128437_("Pos", 6);
        Vec3 currentPosition = new Vec3(posList.m_128772_(0), posList.m_128772_(1), posList.m_128772_(2));
        BlockPos blockPos = currentTarget = targetBlock != null ? targetBlock : originBlock;
        if (currentTarget == null) {
            stopTrackingNextTick.add(drone.m_128342_("UUID"));
            return;
        }
        Vec3 flatTarget = currentTarget.m_252807_().m_82542_(1.0, 0.0, 1.0);
        Vec3 flatPosition = currentPosition.m_82542_(1.0, 0.0, 1.0);
        float speed = 2.4f;
        Vec3 delta = flatTarget.m_82546_(flatPosition).m_82541_().m_82490_((double)speed);
        currentPosition = currentPosition.m_82549_(delta);
        drone.m_128365_("Pos", (Tag)DroneHandler.newDoubleList(currentPosition.f_82479_, currentPosition.f_82480_, currentPosition.f_82481_));
        if (targetBlock != null && flatPosition.m_82554_(targetBlock.m_252807_().m_82542_(1.0, 0.0, 1.0)) < 5.0) {
            drone.m_128405_("StoredMapPosX", targetBlock.m_123341_());
            drone.m_128405_("StoredMapPosY", targetBlock.m_123342_());
            drone.m_128405_("StoredMapPosZ", targetBlock.m_123343_());
            drone.m_128473_("TargetBlockX");
            drone.m_128473_("TargetBlockY");
            drone.m_128473_("TargetBlockZ");
        }
        if (originBlock != null && flatPosition.m_82554_(originBlock.m_252807_().m_82542_(1.0, 0.0, 1.0)) < 5.0) {
            drone.m_128473_("OriginBlockX");
            drone.m_128473_("OriginBlockY");
            drone.m_128473_("OriginBlockZ");
        }
    }

    private static ListTag newDoubleList(double ... ds) {
        ListTag listTag = new ListTag();
        for (double d : ds) {
            listTag.add((Object)DoubleTag.m_128500_((double)d));
        }
        return listTag;
    }

    private static Vec3 getAdjustedLoadPosition(ServerLevel level, Vec3 position) {
        int upper = 0;
        int lower = 0;
        boolean hitUpper = false;
        boolean hitLower = false;
        for (int i = 0; !(i >= 50 || hitLower && hitUpper); ++i) {
            if (!hitUpper) {
                if (level.m_46859_(BlockPos.m_274446_((Position)position.m_231075_(Direction.UP, (double)i)))) {
                    upper = i;
                } else {
                    hitUpper = true;
                }
            }
            if (hitLower) continue;
            if (level.m_46859_(BlockPos.m_274446_((Position)position.m_231075_(Direction.UP, (double)(-i))))) {
                lower = -i;
                continue;
            }
            hitLower = true;
        }
        return position.m_231075_(Direction.UP, (double)((float)(upper + lower) / 2.0f));
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        DroneHandler.server = server;
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        storage.m_164861_(this::load, () -> this, "Drones");
    }

    public DroneHandler load(CompoundTag nbt) {
        CompoundTag levels = nbt.m_128469_("Drones");
        levels.m_128431_().forEach(dimensionKey -> {
            ListTag drones = levels.m_128437_(dimensionKey, 10);
            ServerLevel level = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionKey)));
            drones.forEach(arg_0 -> DroneHandler.lambda$load$8((Level)level, arg_0));
        });
        CreateMissiles.LOGGER.info("Drones loaded");
        ListTag hitList = nbt.m_128437_("HitList", 10);
        hitList.forEach(tag -> killEntityWhenever.add(UUID.fromString(tag.m_7916_())));
        return this;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        CreateMissiles.LOGGER.info("Saving drones");
        CompoundTag data = new CompoundTag();
        server.m_129785_().forEach(serverLevel -> {
            ListTag droneListData = new ListTag();
            droneListData.addAll(((HashMap)drones.get((LevelAccessor)serverLevel)).values());
            data.m_128365_(serverLevel.m_46472_().m_135782_().m_135815_(), (Tag)droneListData);
        });
        compoundTag.m_128365_("Drones", (Tag)data);
        ListTag hitList = new ListTag();
        hitList.addAll(killEntityWhenever.stream().map(uuid -> StringTag.m_129297_((String)uuid.toString())).toList());
        compoundTag.m_128365_("HitList", (Tag)hitList);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            drones = new WorldAttached<HashMap<UUID, CompoundTag>>(l -> new HashMap()){};
            entityCache = new HashMap();
            killEntityWhenever = new HashSet<UUID>();
            stopTrackingNextTick = new HashSet<UUID>();
            server = null;
            instance = null;
        }
        return compoundTag;
    }

    private static /* synthetic */ void lambda$load$8(Level level, Tag tag) {
        CompoundTag drone = (CompoundTag)tag;
        ((HashMap)drones.get((LevelAccessor)level)).put(drone.m_128342_("UUID"), drone);
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

