/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.woukie.createmissiles.block.navigationpanel.messages.ClickFuelMessage;
import net.woukie.createmissiles.block.navigationpanel.messages.ClickMapMessage;
import net.woukie.createmissiles.inventory.AbstractBasicMenu;
import net.woukie.createmissiles.inventory.InvisibleSlot;
import net.woukie.createmissiles.registry.Items;
import net.woukie.createmissiles.registry.Menus;
import net.woukie.createmissiles.registry.Packets;
import org.jetbrains.annotations.NotNull;

public class NavigationPanelMenu
extends AbstractBasicMenu {
    private final ContainerData containerData;
    private final Container assemblyPanelContainer;

    public NavigationPanelMenu(int id, final Inventory playerInventory, Container container, ContainerData containerData, Container assemblyPanelContainer) {
        super((MenuType)Menus.NAVIGATION_PANEL.get(), id, container);
        int j;
        NavigationPanelMenu.m_38869_((Container)container, (int)1);
        NavigationPanelMenu.m_38886_((ContainerData)containerData, (int)17);
        this.containerData = containerData;
        this.assemblyPanelContainer = assemblyPanelContainer;
        this.m_38897_(new Slot(container, 0, 66, 35){

            public boolean m_5857_(@NotNull ItemStack itemStack) {
                if (!itemStack.m_150930_(net.minecraft.world.item.Items.f_42573_)) {
                    return false;
                }
                MapItemSavedData data = MapItem.m_42853_((ItemStack)itemStack, (Level)playerInventory.f_35978_.m_9236_());
                if (data == null) {
                    return false;
                }
                for (MapDecoration mapDecoration : data.m_164811_()) {
                    if (mapDecoration.m_77803_() != MapDecoration.Type.RED_X) continue;
                    return false;
                }
                return !data.m_164810_();
            }
        });
        NavigationPanelMenu.m_38869_((Container)assemblyPanelContainer, (int)3);
        this.m_38897_(new InvisibleSlot(assemblyPanelContainer, 0));
        this.m_38897_(new InvisibleSlot(assemblyPanelContainer, 1));
        this.m_38897_(new InvisibleSlot(assemblyPanelContainer, 2));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)playerInventory, j, 8 + j * 18, 142));
        }
        this.m_38884_(containerData);
    }

    public NavigationPanelMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(17), (Container)new SimpleContainer(3));
    }

    public int getMapCrosshairX() {
        return this.containerData.m_6413_(0);
    }

    public int getMapCrosshairZ() {
        return this.containerData.m_6413_(1);
    }

    public BlockPos getTarget() {
        if (this.containerData.m_6413_(2) == 0) {
            return null;
        }
        return new BlockPos(this.containerData.m_6413_(3), this.containerData.m_6413_(4), this.containerData.m_6413_(5));
    }

    public BlockPos getSource() {
        return new BlockPos(this.containerData.m_6413_(6), this.containerData.m_6413_(7), this.containerData.m_6413_(8));
    }

    public double getFuelPercent() {
        int combinedBits = this.containerData.m_6413_(9) << 16 | this.containerData.m_6413_(10) & 0xFFFF;
        return Float.intBitsToFloat(combinedBits);
    }

    public boolean launchPadExists() {
        return this.containerData.m_6413_(11) == 1;
    }

    public boolean assemblyPanelAbsent() {
        return this.containerData.m_6413_(12) != 1;
    }

    public ItemStack getMap() {
        ItemStack item = this.m_38853_(0).m_7993_();
        if (!item.m_150930_(net.minecraft.world.item.Items.f_42573_)) {
            return null;
        }
        return item;
    }

    public ItemStack getWarhead() {
        if (this.assemblyPanelAbsent()) {
            return null;
        }
        ItemStack item = this.assemblyPanelContainer.m_8020_(0);
        if (!item.m_150930_((Item)Items.WARHEAD_ASSEMBLY.get())) {
            return null;
        }
        return item;
    }

    public ItemStack getChassis() {
        if (this.assemblyPanelAbsent()) {
            return null;
        }
        ItemStack item = this.assemblyPanelContainer.m_8020_(1);
        if (!item.m_150930_((Item)Items.CHASSIS_ASSEMBLY.get())) {
            return null;
        }
        return item;
    }

    public ItemStack getThruster() {
        if (this.assemblyPanelAbsent()) {
            return null;
        }
        ItemStack item = this.assemblyPanelContainer.m_8020_(2);
        if (!item.m_150930_((Item)Items.THRUSTER_ASSEMBLY.get())) {
            return null;
        }
        return item;
    }

    public void clickMap(double x, double z) {
        Packets.NAVIGATION_PANEL_CLICK_MAP.sendToServer((Object)new ClickMapMessage(this.getSource(), x, z));
    }

    public void clickFuel(float fuelClickZ) {
        Packets.NAVIGATION_PANEL_CLICK_FUEL.sendToServer((Object)new ClickFuelMessage(this.getSource(), fuelClickZ));
    }

    public float getUpperLaunchAngle() {
        int combinedBits = this.containerData.m_6413_(13) << 16 | this.containerData.m_6413_(14) & 0xFFFF;
        return Float.intBitsToFloat(combinedBits);
    }

    public float getLowerLaunchAngle() {
        int combinedBits = this.containerData.m_6413_(15) << 16 | this.containerData.m_6413_(16) & 0xFFFF;
        return Float.intBitsToFloat(combinedBits);
    }
}

