/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.item.assembly;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.recipe.MissilePartRecipe;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblyItem
extends Item {
    public AssemblyItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component m_7626_(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null) {
            MissilePartType type = PartTypes.get(new ResourceLocation(compoundTag.m_128461_("PartType")));
            if (type == null) {
                return Component.m_237115_((String)"item.createmissiles.assembly_invalid");
            }
            return type.getDisplayName();
        }
        return super.m_7626_(itemStack);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return;
        }
        Optional<MissilePartRecipe> recipe = MissilePartRecipe.fromResourceLocation(level, new ResourceLocation(compoundTag.m_128461_("PartType")));
        if (recipe.isPresent()) {
            NonNullList<MissileIngredient> ingredients = recipe.get().getMissileIngredients();
            ingredients.forEach(ingredient -> {
                List<ItemStack> items = ingredient.getAllValidItems();
                Component[] names = items.stream().map(ItemStack::m_41611_).toList().toArray(new Component[0]);
                String name = names[(int)((float)Util.m_137550_() / 1000.0f) % names.length].getString();
                list.add((Component)Component.m_237113_((String)(ingredient.count() + " " + name.substring(1, name.length() - 1))));
            });
        }
    }

    public static ItemStack createWith(ResourceLocation partTypeResourceLocation, ItemLike item) {
        ItemStack itemStack = new ItemStack(item);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128359_("PartType", partTypeResourceLocation.toString());
        itemStack.m_41751_(compoundTag);
        return itemStack;
    }
}

