/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;

public class Trajectories
extends SavedData {
    private final List<Trajectory> activeTrajectories = new ArrayList<Trajectory>();
    private final HashMap<UUID, Entity> entityCache = new HashMap();
    private final List<UUID> killEntityWhenever = new ArrayList<UUID>();
    private static Trajectories instance;
    private static boolean initialized;
    private static boolean destroyOnSave;
    private static MinecraftServer server;

    private Trajectories() {
    }

    public static Trajectories get() {
        if (instance == null) {
            instance = new Trajectories();
        }
        return instance;
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        Trajectories.server = server;
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        storage.m_164861_(this::load, () -> this, "trajectory");
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.m_77762_();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        this.killEntityWhenever.removeIf(uuid -> {
            Iterable levels = server.m_129785_();
            Iterator iterator = levels.iterator();
            if (iterator.hasNext()) {
                ServerLevel level = (ServerLevel)iterator.next();
                Entity e = level.m_8791_(uuid);
                if (e == null) {
                    return false;
                }
                e.m_146870_();
                this.entityCache.remove(e.m_20148_());
                return true;
            }
            return false;
        });
        this.activeTrajectories.forEach(trajectory -> {
            ServerLevel level = server.m_129880_(trajectory.getLevelKey());
            if (level == null) {
                return;
            }
            if (trajectory.getEntityId() == null) {
                MissileEntity entity = new MissileEntity((EntityType)EntityTypes.MISSILE.get(), (Level)level);
                UUID uuid = UUID.randomUUID();
                entity.m_20084_(uuid);
                trajectory.updateEntityModel(entity);
                trajectory.setEntityId(uuid);
                level.m_7967_((Entity)entity);
                this.entityCache.put(uuid, entity);
                this.m_77762_();
                return;
            }
            UUID uuid = trajectory.getEntityId();
            Entity entity = this.entityCache.computeIfAbsent(uuid, uuid1 -> level.m_8791_(uuid));
            if (entity == null || entity.m_213877_() || !entity.m_6084_()) {
                this.killEntityWhenever.add(uuid);
                this.entityCache.remove(uuid);
                trajectory.setEntityId(null);
            }
            trajectory.tick();
            trajectory.warheadType.onTick((Trajectory)trajectory, server);
            trajectory.chassisType.onTick((Trajectory)trajectory, server);
            trajectory.thrusterType.onTick((Trajectory)trajectory, server);
            trajectory.updateEntityModel((MissileEntity)entity);
        });
        this.activeTrajectories.removeIf(trajectory -> {
            Entity entity;
            if (!trajectory.getSpent()) {
                return false;
            }
            ServerLevel level = server.m_129880_(trajectory.getLevelKey());
            if (level != null && (entity = level.m_8791_(trajectory.getEntityId())) != null) {
                entity.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.m_77762_();
            return true;
        });
    }

    public void launch(Trajectory trajectory) {
        this.activeTrajectories.add(trajectory);
    }

    public Trajectories load(CompoundTag nbt) {
        ListTag trajectories = nbt.m_128437_("Trajectories", 10);
        trajectories.forEach(tag -> {
            CompoundTag savedData = (CompoundTag)tag;
            ThrusterType thrusterType = (ThrusterType)PartTypes.get(new ResourceLocation(savedData.m_128461_("ThrusterType")));
            this.launch(thrusterType.constructTrajectory(savedData, server));
        });
        ListTag hitList = nbt.m_128437_("HitList", 10);
        this.killEntityWhenever.addAll(hitList.stream().map(tag -> UUID.fromString(tag.toString())).toList());
        CreateMissiles.LOGGER.info("Trajectories loaded");
        return this;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        ListTag trajectories = new ListTag();
        for (Trajectory trajectory : this.activeTrajectories) {
            CreateMissiles.LOGGER.info("Saving trajectory at {}", (Object)trajectory.position);
            trajectories.add((Object)trajectory.saveTo(new CompoundTag()));
        }
        ListTag hitList = new ListTag();
        hitList.addAll(this.killEntityWhenever.stream().map(uuid -> StringTag.m_129297_((String)uuid.toString())).toList());
        compoundTag.m_128365_("Trajectories", (Tag)trajectories);
        compoundTag.m_128365_("HitList", (Tag)hitList);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            server = null;
            this.activeTrajectories.clear();
            this.entityCache.clear();
            this.killEntityWhenever.clear();
            instance = null;
        }
        return compoundTag;
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

