/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles;

import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.PartTypes;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public abstract class Trajectory {
    protected ResourceKey<Level> levelKey;
    protected int tick;
    protected UUID entityId;
    protected WarheadType warheadType;
    protected ChassisType chassisType;
    protected ThrusterType thrusterType;
    protected Vector3d initialPosition;
    protected Vector3d position;
    protected Vector3d targetPosition;
    protected Vector3d lastPosition;
    protected CompoundTag warheadData;
    protected CompoundTag chassisData;
    protected CompoundTag thrusterData;
    private boolean spent;

    public Trajectory(ResourceKey<Level> levelKey, Vector3d initialPosition, Vector3d targetPosition, WarheadType warheadType, ChassisType chassisType, ThrusterType thrusterType, Container container) {
        this.levelKey = levelKey;
        this.initialPosition = new Vector3d((Vector3dc)initialPosition);
        this.position = new Vector3d((Vector3dc)initialPosition);
        this.targetPosition = new Vector3d((Vector3dc)targetPosition);
        this.lastPosition = new Vector3d((Vector3dc)initialPosition);
        this.tick = 0;
        this.warheadType = warheadType;
        this.chassisType = chassisType;
        this.thrusterType = thrusterType;
        if (container != null) {
            this.warheadData = warheadType.saveTo(container, new CompoundTag());
            this.chassisData = chassisType.saveTo(container, new CompoundTag());
            this.thrusterData = thrusterType.saveTo(container, new CompoundTag());
        }
    }

    public Trajectory(CompoundTag data, MinecraftServer server) {
        this.loadFrom(data, server);
    }

    public void tick() {
        ++this.tick;
    }

    public CompoundTag saveTo(CompoundTag data) {
        data.m_128359_("Dimension", this.levelKey.m_135782_().m_135815_());
        if (this.entityId != null) {
            data.m_128362_("EntityID", this.entityId);
        }
        data.m_128405_("Tick", this.tick);
        data.m_128347_("InitialPositionX", this.initialPosition.x);
        data.m_128347_("InitialPositionY", this.initialPosition.y);
        data.m_128347_("InitialPositionZ", this.initialPosition.z);
        data.m_128347_("PositionX", this.position.x);
        data.m_128347_("PositionY", this.position.y);
        data.m_128347_("PositionZ", this.position.z);
        data.m_128347_("TargetPositionX", this.targetPosition.x);
        data.m_128347_("TargetPositionY", this.targetPosition.y);
        data.m_128347_("TargetPositionZ", this.targetPosition.z);
        data.m_128347_("LastPositionX", this.lastPosition.x);
        data.m_128347_("LastPositionY", this.lastPosition.y);
        data.m_128347_("LastPositionZ", this.lastPosition.z);
        data.m_128359_("WarheadType", this.warheadType.getResourceLocation().toString());
        data.m_128359_("ChassisType", this.chassisType.getResourceLocation().toString());
        data.m_128359_("ThrusterType", this.thrusterType.getResourceLocation().toString());
        data.m_128365_("WarheadData", (Tag)this.warheadData);
        data.m_128365_("ChassisData", (Tag)this.chassisData);
        data.m_128365_("ThrusterData", (Tag)this.thrusterData);
        return data;
    }

    private void loadFrom(CompoundTag data, MinecraftServer server) {
        String dimension = data.m_128461_("Dimension");
        this.levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimension));
        this.entityId = data.m_128403_("EntityID") ? data.m_128342_("EntityID") : null;
        this.tick = data.m_128451_("Tick");
        this.warheadType = (WarheadType)PartTypes.get(new ResourceLocation(data.m_128461_("WarheadType")));
        this.chassisType = (ChassisType)PartTypes.get(new ResourceLocation(data.m_128461_("ChassisType")));
        this.thrusterType = (ThrusterType)PartTypes.get(new ResourceLocation(data.m_128461_("ThrusterType")));
        this.initialPosition = new Vector3d(data.m_128459_("InitialPositionX"), data.m_128459_("InitialPositionY"), data.m_128459_("InitialPositionZ"));
        this.position = new Vector3d(data.m_128459_("PositionX"), data.m_128459_("PositionY"), data.m_128459_("PositionZ"));
        this.targetPosition = new Vector3d(data.m_128459_("TargetPositionX"), data.m_128459_("TargetPositionY"), data.m_128459_("TargetPositionZ"));
        this.lastPosition = new Vector3d(data.m_128459_("LastPositionX"), data.m_128459_("LastPositionY"), data.m_128459_("LastPositionZ"));
        this.warheadData = data.m_128469_("WarheadData");
        this.chassisData = data.m_128469_("ChassisData");
        this.thrusterData = data.m_128469_("ThrusterData");
    }

    public void updateEntityModel(MissileEntity entity) {
        if (entity == null) {
            return;
        }
        Vector3d p = this.getPosition();
        entity.m_6034_(p.x, p.y, p.z);
        entity.setWarheadBuildPercent(100);
        entity.setChassisBuildPercent(100);
        entity.setThrusterBuildPercent(100);
        entity.setWarheadType(this.warheadType.getResourceLocation());
        entity.setChassisType(this.chassisType.getResourceLocation());
        entity.setThrusterType(this.thrusterType.getResourceLocation());
        entity.setFlying(true);
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public WarheadType getWarheadType() {
        return this.warheadType;
    }

    public ChassisType getChassisType() {
        return this.chassisType;
    }

    public ThrusterType getThrusterType() {
        return this.thrusterType;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getTargetPosition() {
        return this.targetPosition;
    }

    public Vector3d getInitialPosition() {
        return this.initialPosition;
    }

    public Vector3d getLastPosition() {
        return this.lastPosition;
    }

    public int getTick() {
        return this.tick;
    }

    public CompoundTag getWarheadData() {
        return this.warheadData;
    }

    public CompoundTag getChassisData() {
        return this.chassisData;
    }

    public CompoundTag getThrusterData() {
        return this.thrusterData;
    }

    public void setSpent(boolean spent) {
        this.spent = spent;
    }

    public boolean getSpent() {
        return this.spent;
    }

    public void setEntityId(UUID uuid) {
        this.entityId = uuid;
    }
}

