/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.woukie.createmissiles.ExplosionResistanceOverrides;
import net.woukie.createmissiles.Util;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ExplodingAreaWorker
implements Runnable {
    private final BlockPos start;
    private final BlockPos end;
    private final Vector3d origin;
    private final Level level;
    private final Double power;
    private final Double decay;
    private final ConcurrentHashMap<BlockPos, Float> hardnessMap;
    private final double maxDistance;
    private PriorityBlockingQueue<BlockPos> removeBlocks;
    private PriorityBlockingQueue<BlockPos> brokenBlocks;
    private boolean calculatedBlocks = false;
    private boolean doneX = false;
    private boolean doneY = false;
    private boolean doneZ = false;
    private int countX = 0;
    private int countY = 0;
    private int countZ = 0;
    private int deadRayCount = 0;
    private boolean endEarly = false;
    public static final double HARDNESS_MULTIPLIER = 0.3;
    public static final double HARDNESS_OFFSET = 0.315;

    public ExplodingAreaWorker(BlockPos start, BlockPos end, BlockPos originBlock, Level level, Double power, ConcurrentHashMap<BlockPos, Float> hardnessMap, Double decay) {
        this.start = start;
        this.end = end;
        this.origin = new Vector3d((double)originBlock.m_123341_() + 0.5, (double)originBlock.m_123342_() + 0.5, (double)originBlock.m_123343_() + 0.5);
        this.level = level;
        this.power = power;
        this.decay = decay;
        this.hardnessMap = hardnessMap;
        this.maxDistance = (this.power - this.decay - 0.315) / 0.315;
        this.brokenBlocks = new PriorityBlockingQueue();
        this.removeBlocks = new PriorityBlockingQueue();
    }

    @Override
    public void run() {
        boolean includeUpperZ;
        boolean includeLowerX = this.origin.x - (double)this.start.m_123341_() - 0.5 >= (double)((int)this.maxDistance);
        boolean includeUpperX = (double)this.end.m_123341_() + 0.5 - this.origin.x >= (double)((int)this.maxDistance - 1);
        boolean includeLowerY = this.origin.y - (double)this.start.m_123342_() - 0.5 >= (double)((int)this.maxDistance);
        boolean includeUpperY = (double)this.end.m_123342_() + 0.5 - this.origin.y >= (double)((int)this.maxDistance - 1);
        boolean includeLowerZ = this.origin.z - (double)this.start.m_123343_() - 0.5 >= (double)((int)this.maxDistance);
        boolean bl = includeUpperZ = (double)this.end.m_123343_() + 0.5 - this.origin.z >= (double)((int)this.maxDistance - 1);
        while (!(this.doneX && this.doneY && this.doneZ)) {
            if (this.endEarly) {
                return;
            }
            if (this.deadRayCount > 20) {
                this.doneX = true;
                this.doneY = true;
                this.doneZ = true;
                break;
            }
            this.processX(includeLowerX, includeUpperX);
            this.processY(includeLowerY, includeUpperY);
            this.processZ(includeLowerZ, includeUpperZ);
        }
        this.calculatedBlocks = true;
    }

    private void processX(boolean includeLowerX, boolean includeUpperX) {
        if (this.doneX) {
            return;
        }
        if (includeLowerX || includeUpperX) {
            if ((double)this.countX >= this.maxDistance * this.maxDistance) {
                this.doneX = true;
            }
            ++this.countX;
            int z = (int)(Math.random() * (double)(this.end.m_123343_() - this.start.m_123343_())) + this.start.m_123343_();
            int y = (int)(Math.random() * (double)(this.end.m_123342_() - this.start.m_123342_())) + this.start.m_123342_();
            if (includeLowerX) {
                this.traverseBlock(new BlockPos(this.start.m_123341_(), y, z));
            }
            if (includeUpperX) {
                this.traverseBlock(new BlockPos(this.end.m_123341_(), y, z));
            }
            return;
        }
        this.doneX = true;
    }

    private void processY(boolean includeLowerY, boolean includeUpperY) {
        if (this.doneY) {
            return;
        }
        if (includeLowerY || includeUpperY) {
            if ((double)this.countY >= this.maxDistance * this.maxDistance) {
                this.doneY = true;
            }
            ++this.countY;
            int x = (int)(Math.random() * (double)(this.end.m_123341_() - this.start.m_123341_())) + this.start.m_123341_();
            int z = (int)(Math.random() * (double)(this.end.m_123343_() - this.start.m_123343_())) + this.start.m_123343_();
            if (includeLowerY) {
                this.traverseBlock(new BlockPos(x, this.start.m_123342_(), z));
            }
            if (includeUpperY) {
                this.traverseBlock(new BlockPos(x, this.end.m_123342_(), z));
            }
            return;
        }
        this.doneY = true;
    }

    private void processZ(boolean includeLowerZ, boolean includeUpperZ) {
        if (this.doneZ) {
            return;
        }
        if (includeLowerZ || includeUpperZ) {
            if ((double)this.countZ >= this.maxDistance * this.maxDistance) {
                this.doneZ = true;
            }
            ++this.countZ;
            int x = (int)(Math.random() * (double)(this.end.m_123341_() - this.start.m_123341_())) + this.start.m_123341_();
            int y = (int)(Math.random() * (double)(this.end.m_123342_() - this.start.m_123342_())) + this.start.m_123342_();
            if (includeLowerZ) {
                this.traverseBlock(new BlockPos(x, y, this.start.m_123343_()));
            }
            if (includeUpperZ) {
                this.traverseBlock(new BlockPos(x, y, this.end.m_123343_()));
            }
            return;
        }
        this.doneZ = true;
    }

    private void traverseBlock(BlockPos blockPos) {
        if (this.endEarly) {
            return;
        }
        double startPower = (0.8 + Math.random() * 0.2) * this.power;
        AtomicReference<Float> totalHardness = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Integer> passedCount = new AtomicReference<Integer>(0);
        ++this.deadRayCount;
        AtomicInteger blocksRemoved = new AtomicInteger();
        Util.traverseSupercover(this.origin, new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5), traversedPos -> {
            if (this.endEarly) {
                return true;
            }
            double distance = traversedPos.distance((Vector3dc)this.origin);
            if (distance > this.maxDistance) {
                return true;
            }
            BlockPos traversedBlockPos = BlockPos.m_274561_((double)traversedPos.x, (double)traversedPos.y, (double)traversedPos.z);
            boolean alreadyCalculated = this.hardnessMap.containsKey(traversedBlockPos);
            float hardness = this.hardnessMap.computeIfAbsent(traversedBlockPos, p -> Float.valueOf(ExplosionResistanceOverrides.getResistance(this.level.m_8055_(p).m_60734_()))).floatValue();
            totalHardness.updateAndGet(current -> Float.valueOf(current.floatValue() + hardness));
            passedCount.updateAndGet(a -> {
                a = a + 1;
                return a;
            });
            if (!alreadyCalculated) {
                int passedBlocks = Math.max((Integer)passedCount.get(), 1);
                double averageHardness = (double)((Float)totalHardness.get()).floatValue() / (double)passedBlocks;
                double powerLeft = startPower - (0.3 * averageHardness + 0.315 + this.decay) * (distance + 0.3);
                if (powerLeft > 0.0) {
                    blocksRemoved.getAndIncrement();
                    if (Math.random() > 1.0 / startPower) {
                        this.removeBlocks.offer(traversedBlockPos);
                    } else {
                        this.brokenBlocks.offer(traversedBlockPos);
                    }
                } else {
                    return true;
                }
            }
            return false;
        });
        if ((double)blocksRemoved.get() / (double)passedCount.get().intValue() != 0.0) {
            this.deadRayCount = 0;
        }
    }

    public boolean isComplete() {
        return this.calculatedBlocks && this.brokenBlocks.isEmpty() && this.removeBlocks.isEmpty();
    }

    public boolean processBlock(Level level) {
        if (this.endEarly) {
            return false;
        }
        BlockPos blockPos = this.removeBlocks.poll();
        boolean dropBlock = false;
        if (blockPos == null) {
            blockPos = this.brokenBlocks.poll();
            dropBlock = true;
        }
        if (blockPos == null) {
            return false;
        }
        if (level.m_8055_(blockPos).m_60713_(Blocks.f_50260_)) {
            return true;
        }
        if (!dropBlock) {
            level.m_7471_(blockPos, true);
            return true;
        }
        BlockState state = level.m_8055_(blockPos);
        if (state.m_60795_()) {
            return true;
        }
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49881_((BlockState)state, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, null, (ItemStack)ItemStack.f_41583_);
        level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
        return true;
    }

    public void endEarly() {
        this.endEarly = true;
    }

    public CompoundTag save() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("CountX", this.countX);
        data.m_128405_("CountY", this.countY);
        data.m_128405_("CountZ", this.countZ);
        data.m_128428_("BrokenBlocks", this.brokenBlocks.stream().map(BlockPos::m_121878_).toList());
        data.m_128428_("RemoveBlocks", this.removeBlocks.stream().map(BlockPos::m_121878_).toList());
        return data;
    }

    public void load(CompoundTag data) {
        this.countX = data.m_128451_("CountX");
        this.countY = data.m_128451_("CountY");
        this.countZ = data.m_128451_("CountZ");
        this.brokenBlocks = new PriorityBlockingQueue<BlockPos>(Arrays.stream(data.m_128467_("BrokenBlocks")).mapToObj(BlockPos::m_122022_).toList());
        this.removeBlocks = new PriorityBlockingQueue<BlockPos>(Arrays.stream(data.m_128467_("RemoveBlocks")).mapToObj(BlockPos::m_122022_).toList());
    }
}

