/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.client.CreateFlashMessage;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.registry.Packets;
import org.jetbrains.annotations.NotNull;

public class ExplosionHandler
extends SavedData {
    private List<Explosion> explosions = new ArrayList<Explosion>();
    private static MinecraftServer server;
    private static ExplosionHandler instance;
    private static boolean initialized;
    private static boolean destroyOnSave;

    private ExplosionHandler() {
    }

    public static ExplosionHandler get() {
        if (instance == null) {
            instance = new ExplosionHandler();
        }
        return instance;
    }

    public void createExplosion(Explosion explosion) {
        this.createExplosion(explosion, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)251), 1000);
    }

    public void createExplosion(Explosion explosion, Integer colour, Integer length) {
        this.explosions.add(explosion);
        explosion.damageEntities();
        explosion.startCrunching();
        explosion.getLevel().m_6907_().forEach(player -> {
            double distance = player.m_20182_().m_82554_(explosion.getOrigin().m_252807_());
            if (distance < (double)(explosion.getMaxRadius() * 4)) {
                Packets.CREATE_FLASH.sendToPlayer((ServerPlayer)player, (Object)new CreateFlashMessage(colour, explosion.getOrigin(), explosion.getMaxRadius(), explosion.getPower(), length));
            }
        });
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CreateMissiles.LOGGER.info("Saving explosions");
        ListTag explosions = new ListTag();
        explosions.addAll(this.explosions.stream().map(Explosion::save).toList());
        compoundTag.m_128365_("Explosions", (Tag)explosions);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            server = null;
            this.explosions.clear();
            instance = null;
        }
        return compoundTag;
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.explosions.forEach(Explosion::stopCrunching);
        this.m_77762_();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        this.explosions.removeIf(explosion -> {
            explosion.serverTick(server);
            if (explosion.isComplete()) {
                CreateMissiles.LOGGER.info("Explosion at {} is complete", (Object)explosion.getOrigin().m_123344_());
                this.m_77762_();
                return true;
            }
            return false;
        });
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        ExplosionHandler.server = server;
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        storage.m_164861_(this::load, () -> this, "Explosions");
    }

    public ExplosionHandler load(CompoundTag nbt) {
        this.explosions = new ArrayList<Explosion>(nbt.m_128437_("Explosions", 10).stream().map(tag -> Explosion.load((CompoundTag)tag, server)).toList());
        CreateMissiles.LOGGER.info("Explosions loaded");
        this.explosions.forEach(Explosion::startCrunching);
        return this;
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

