/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.thrusters;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelBlockEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import org.joml.Vector3d;

public class FireworkThruster
extends ThrusterType {
    @Override
    public Trajectory constructTrajectory(CompoundTag data, MinecraftServer server) {
        return new BallisticTrajectory(data, server);
    }

    @Override
    public void onTick(Trajectory trajectory, MinecraftServer server) {
        super.onTick(trajectory, server);
        Vector3d p = trajectory.getPosition();
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level != null) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, p.x, p.y, p.z, 5, 0.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Trajectory createTrajectory(Level level, Vector3d start, Vector3d target, WarheadType warheadType, ChassisType chassisType, ThrusterType thrusterType, Container container, NavigationPanelBlockEntity navPanel) {
        return new BallisticTrajectory(level, start, target, warheadType, chassisType, thrusterType, container, navPanel.getThrustDurationPercent());
    }

    @Override
    public float getThrust() {
        return 825.0f;
    }

    @Override
    public float getBurnRate() {
        return 15.0f;
    }

    @Override
    public float getMass() {
        return 5.0f;
    }

    @Override
    public void onLaunch(Trajectory trajectory, ServerLevel level) {
        Vector3d p = trajectory.getPosition();
        level.m_6263_(null, p.x, p.y, p.z, SoundEvents.f_11932_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "firework_thruster");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"thrusters.createmissiles.firework_thruster");
    }
}

