/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.item.BiomeVialItem;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.Items;

public class BiomeBrushWarhead
extends WarheadType {
    private final int radius = 16;

    @Override
    public float getMass() {
        return 7.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        Vec3i center = new Vec3i((int)hitPosition.f_82479_, (int)hitPosition.f_82480_, (int)hitPosition.f_82481_);
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)center.m_7918_(16, 16, 16), (Vec3i)center.m_7918_(-16, -16, -16));
        ArrayList<ChunkAccess> list = new ArrayList<ChunkAccess>();
        for (int k = SectionPos.m_123171_((int)boundingBox.m_162398_()); k <= SectionPos.m_123171_((int)boundingBox.m_162401_()); ++k) {
            for (int l = SectionPos.m_123171_((int)boundingBox.m_162395_()); l <= SectionPos.m_123171_((int)boundingBox.m_162399_()); ++l) {
                ChunkAccess chunkAccess = level.m_6522_(l, k, ChunkStatus.f_62326_, false);
                if (chunkAccess == null) {
                    return;
                }
                list.add(chunkAccess);
            }
        }
        ResourceLocation reference = new ResourceLocation(trajectory.getWarheadData().m_128461_("biome"));
        Optional registryOptional = level.m_9598_().m_6632_(Registries.f_256952_);
        if (registryOptional.isEmpty()) {
            return;
        }
        Optional biomeHolderOptional = ((Registry)registryOptional.get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)reference));
        if (biomeHolderOptional.isEmpty()) {
            return;
        }
        for (ChunkAccess chunkAccess : list) {
            chunkAccess.m_183442_(BiomeBrushWarhead.makeResolver(chunkAccess, boundingBox, (Holder<Biome>)((Holder)biomeHolderOptional.get()), holder -> true), level.m_7726_().m_214994_().m_224579_());
            chunkAccess.m_8092_(true);
        }
        level.m_7726_().f_8325_.m_274524_(list);
        level.m_247517_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.NEUTRAL);
        level.m_247517_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11934_, SoundSource.NEUTRAL);
        for (int i = 0; i < 20; ++i) {
            Vec3 pos = new Vec3(Math.random() * 16.0 * 2.0, Math.random() * 16.0 * 2.0, Math.random() * 16.0 * 2.0).m_82549_(hitPosition).m_82492_(16.0, 16.0, 16.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123767_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 2.0);
        }
    }

    private static BiomeResolver makeResolver(ChunkAccess chunkAccess, BoundingBox boundingBox, Holder<Biome> holder, Predicate<Holder<Biome>> predicate) {
        return (i, j, k, sampler) -> {
            int l = QuartPos.m_175402_((int)i);
            int m = QuartPos.m_175402_((int)j);
            int n = QuartPos.m_175402_((int)k);
            Holder holder2 = chunkAccess.m_203495_(i, j, k);
            if (boundingBox.m_260866_(l, m, n) && predicate.test(holder2)) {
                return holder;
            }
            return holder2;
        };
    }

    @Override
    public CompoundTag saveTo(Container container, CompoundTag data) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            BiomeVialItem item;
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_150930_((Item)Items.BIOME_VIAL.get()) || !(item = (BiomeVialItem)itemStack.m_41720_()).isFull(itemStack)) continue;
            data.m_128359_("biome", itemStack.m_41783_().m_128461_("biome"));
            return data;
        }
        return super.saveTo(container, data);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "biome_brush_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.biome_brush_warhead");
    }
}

