/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.entity.BlazingballEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.EntityTypes;

public class BlazingWarhead
extends WarheadType {
    private static final float fireballVelocity = 3.0f;
    private static final float fireballSlowVelocity = 1.5f;

    @Override
    public float getMass() {
        return 22.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 15.0));
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            BlazingballEntity entity = new BlazingballEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityTypes.BLAZINGBALL.get()), (Level)level);
            entity.m_20242_(false);
            entity.m_146884_(hitPosition.m_82520_(0.0, 1.5, 0.0));
            float velocity = 3.0f;
            if (i >= 20) {
                velocity = 1.5f;
            }
            entity.m_20334_(random.nextDouble() * (double)velocity - (double)(velocity / 2.0f), random.nextDouble() * (double)velocity, random.nextDouble() * (double)velocity - (double)(velocity / 2.0f));
            level.m_7967_((Entity)entity);
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_, random.nextGaussian() * 0.05, 0.005, random.nextGaussian() * 0.05);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "blazing_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.blazing_warhead");
    }
}

