/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import org.joml.Vector3d;

public class ExcavatorWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 22.5f;
    }

    @Override
    public CompoundTag saveTo(Container container, CompoundTag data) {
        data.m_128405_("Charges", this.getInitialCharges());
        data.m_128347_("DetonationGap", 0.0);
        return data;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "excavator_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.excavator_warhead");
    }

    @Override
    public void onTick(Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null || trajectory.getTick() <= 20) {
            return;
        }
        Vector3d end = trajectory.getPosition();
        if (trajectory.getWarheadData().m_128451_("Charges") != this.getInitialCharges()) {
            Vector3d start = trajectory.getLastPosition();
            this.detonateLine(new Vec3(start.x, start.y, start.z), new Vec3(end.x, end.y, end.z), level, trajectory);
        } else {
            Vec3 hitPosition = this.hitPosition(trajectory, server);
            if (trajectory.getPosition().y < (double)level.m_141937_()) {
                hitPosition = new Vec3(trajectory.getPosition().x, trajectory.getPosition().y, trajectory.getPosition().z);
            }
            if (hitPosition != null) {
                this.detonateLine(hitPosition, new Vec3(end.x, end.y, end.z), level, trajectory);
            }
        }
        if (trajectory.getWarheadData().m_128451_("Charges") <= 0) {
            trajectory.setSpent(true);
        }
    }

    private void detonateLine(Vec3 start, Vec3 end, ServerLevel level, Trajectory trajectory) {
        int charges = trajectory.getWarheadData().m_128451_("Charges");
        double detonationGap = trajectory.getWarheadData().m_128459_("DetonationGap");
        Vec3 totalDistance = end.m_82546_(start);
        Vec3 stepOffset = totalDistance.m_82541_().m_82490_((double)this.getStepSize());
        Vec3 currentDistance = stepOffset.m_82541_().m_82490_(detonationGap);
        while (currentDistance.m_82553_() < totalDistance.m_82553_() && charges > 0) {
            Vec3 globalPosition = currentDistance.m_82549_(start);
            level.m_5594_(null, BlockPos.m_274446_((Position)globalPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
            ExplosionHandler.get().createExplosion(new Explosion((Level)level, globalPosition, this.getExplosionPower()));
            trajectory.getWarheadData().m_128405_("Charges", --charges);
            currentDistance = currentDistance.m_82549_(stepOffset);
        }
        detonationGap = totalDistance.m_82546_(currentDistance).m_82553_();
        trajectory.getWarheadData().m_128347_("DetonationGap", detonationGap);
    }

    protected int getInitialCharges() {
        return 30;
    }

    protected float getStepSize() {
        return 1.5f;
    }

    protected double getExplosionPower() {
        return 5.0;
    }
}

