/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.parts.warheads.messages.ExplodeFireworkMessage;
import net.woukie.createmissiles.registry.Packets;
import org.joml.Vector3f;

public class FireworkWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 7.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 4.0));
        CompoundTag explosions = trajectory.getWarheadData();
        if (explosions == null || explosions.m_128456_()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_, Math.random() * 0.05, 0.005, Math.random() * 0.05);
        } else {
            ArrayList players = new ArrayList();
            level.m_6907_().forEach(serverPlayer -> {
                BlockPos blockPos = serverPlayer.m_20183_();
                if (blockPos.m_203195_((Position)new Vec3(hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_), 512.0)) {
                    players.add(serverPlayer);
                }
            });
            Vector3f vel = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f impactPosFloat = new Vector3f((float)hitPosition.f_82479_, (float)hitPosition.f_82480_, (float)hitPosition.f_82481_);
            Packets.EXPLODE_FIREWORK.sendToPlayers(players, (Object)new ExplodeFireworkMessage(impactPosFloat, vel, explosions));
        }
    }

    @Override
    public CompoundTag saveTo(Container container, CompoundTag data) {
        ListTag explosions = new ListTag();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_150930_(Items.f_42689_) || itemStack.m_41783_() == null) continue;
            explosions.add((Object)itemStack.m_41737_("Explosion"));
        }
        data.m_128365_("Explosions", (Tag)explosions);
        return data;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "firework_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.firework_warhead");
    }
}

