/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.entity.FrostballEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.EntityTypes;

public class FrostWarhead
extends WarheadType {
    private static final float snowballVelocity = 3.0f;
    private static final float snowballSlowVelocity = 1.5f;

    @Override
    public float getMass() {
        return 15.0f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 10.0));
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            FrostballEntity ball = new FrostballEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityTypes.FROSTBALL.get()), (Level)level);
            ball.m_20242_(false);
            ball.m_146884_(hitPosition.m_82520_(0.0, 1.5, 0.0));
            float velocity = 3.0f;
            if (i >= 20) {
                velocity = 1.5f;
            }
            ball.m_20334_(random.nextDouble() * (double)velocity - (double)(velocity / 2.0f), (random.nextDouble() / 2.0 + 0.5) * (double)velocity, random.nextDouble() * (double)velocity - (double)(velocity / 2.0f));
            level.m_7967_((Entity)ball);
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "frost_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.frost_warhead");
    }
}

