/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.entity.GuardianballEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.EntityTypes;

public class GuardianWarhead
extends WarheadType {
    private static final float ballVelocity = 3.0f;
    private static final float slowBallVelocity = 1.5f;

    @Override
    public float getMass() {
        return 28.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_12278_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 15.0));
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            GuardianballEntity ball = new GuardianballEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityTypes.FROSTBALL.get()), (Level)level);
            ball.m_20242_(false);
            ball.m_146884_(hitPosition.m_82520_(0.0, 1.5, 0.0));
            float velocity = 3.0f;
            if (i >= 20) {
                velocity = 1.5f;
            }
            ball.m_20334_(random.nextDouble() * (double)velocity - (double)(velocity / 2.0f), (random.nextDouble() / 2.0 + 0.5) * (double)velocity, random.nextDouble() * (double)velocity - (double)(velocity / 2.0f));
            level.m_7967_((Entity)ball);
        }
        EntityType.f_20563_.m_262496_(level, BlockPos.m_274446_((Position)hitPosition), MobSpawnType.MOB_SUMMONED);
        Util.locateNearestMatchingBlock(hitPosition, blockPos -> {
            if (level.m_8055_(blockPos).m_60722_((Fluid)Fluids.f_76193_)) {
                level.m_46961_(blockPos, false);
                level.m_7731_(blockPos, Blocks.f_49990_.m_49966_(), 3);
            }
            return false;
        }, 100);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "guardian_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.guardian_warhead");
    }
}

