/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.EntityTypes;

public class MessyWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 37.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 20.0));
        ((EntityType)EntityTypes.MESSY.get()).m_262496_(level, BlockPos.m_274446_((Position)hitPosition), MobSpawnType.MOB_SUMMONED);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "messy_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.messy_warhead");
    }
}

