/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import org.joml.Vector3d;

public class ShulkerBoxWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 15.0f;
    }

    @Override
    public CompoundTag saveTo(Container container, CompoundTag data) {
        ListTag boxes = new ListTag();
        for (int i = this.getStartSlot(); i < this.getEndSlot(); ++i) {
            boolean isShulker;
            ItemStack stack = container.m_8020_(i);
            boolean bl = isShulker = stack.m_150930_(Items.f_42265_) || Arrays.stream(DyeColor.values()).anyMatch(c -> stack.m_150930_(ShulkerBoxBlock.m_56190_((DyeColor)c).m_5456_()));
            if (!isShulker) continue;
            boxes.add((Object)stack.m_41739_(new CompoundTag()));
        }
        data.m_128365_("ShulkerBoxes", (Tag)boxes);
        return data;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ListTag boxes;
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_12418_, SoundSource.HOSTILE, 10.0f, 1.0f);
        CompoundTag data = trajectory.getWarheadData();
        if (data != null && !data.m_128456_() && !(boxes = data.m_128437_("ShulkerBoxes", 10)).isEmpty()) {
            for (int i = 0; i < boxes.size(); ++i) {
                boolean success;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)boxes.m_128728_(i));
                BlockPos emptyBlock = Util.locateAir(hitPosition.m_82520_(0.0, 1.0, 0.0), level, 100);
                if (emptyBlock != null && (success = ((BlockItem)itemStack.m_41720_()).m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)level, emptyBlock, Direction.UP, itemStack, Direction.UP)).m_19077_())) continue;
                DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)itemStack, (int)1, (Direction)Direction.UP, (Position)hitPosition);
            }
        }
    }

    @Override
    public void onLaunch(Trajectory trajectory, ServerLevel level) {
        Vector3d p = trajectory.getPosition();
        level.m_6263_(null, p.x, p.y, p.z, SoundEvents.f_11932_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "shulker_box_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.shulker_box_warhead");
    }
}

