/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.trajectories;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;

public class TrajectoryHelper {
    private static final Vector2d gravity = new Vector2d(0.0, -9.81);
    private static final double deltaTime = 0.05;

    public static double[] generateRange(double start, double end, int size) {
        double[] result = new double[size];
        double step = (end - start) / (double)(size - 1);
        for (int i = 0; i < size; ++i) {
            result[i] = start + (double)i * step;
        }
        return result;
    }

    public static List<Vector2d> simulate(LaunchConfig launchConfig, double newAngle, double newThrustDuration) {
        Vector2d velocity = new Vector2d();
        Vector2d position = new Vector2d();
        ArrayList<Vector2d> missilePositions = new ArrayList<Vector2d>();
        double time = 0.0;
        while (position.y >= (double)(launchConfig.target.m_123342_() - launchConfig.source.m_123342_()) || velocity.y >= 0.0) {
            double currentFlightAngle = Math.atan2(velocity.y, Math.sqrt(velocity.x * velocity.x));
            double approximateForceDueToAirResistance = 0.03 * (velocity.x * velocity.x + velocity.y * velocity.y);
            double horizontalForceDueToAirResistance = Math.cos(currentFlightAngle) * approximateForceDueToAirResistance;
            double verticalForceDueToAirResistance = (double)(-TrajectoryHelper.getSign(velocity.y)) * Math.sin(currentFlightAngle) * approximateForceDueToAirResistance;
            double forceHorizontal = launchConfig.missileConfig.thrust * Math.cos(Math.toRadians(newAngle)) / launchConfig.missileConfig.mass;
            Vector2d acceleration = time >= newThrustDuration ? new Vector2d((double)(-TrajectoryHelper.getSign(velocity.x)) * horizontalForceDueToAirResistance / launchConfig.missileConfig.mass, verticalForceDueToAirResistance / launchConfig.missileConfig.mass + TrajectoryHelper.gravity.y) : new Vector2d((double)(-TrajectoryHelper.getSign(velocity.x)) * horizontalForceDueToAirResistance / launchConfig.missileConfig.mass + forceHorizontal, verticalForceDueToAirResistance / launchConfig.missileConfig.mass + launchConfig.missileConfig.thrust * Math.sin(Math.toRadians(newAngle)) / launchConfig.missileConfig.mass + TrajectoryHelper.gravity.y);
            velocity.add((Vector2dc)acceleration.mul(0.05));
            position.add(velocity.x * 0.05, velocity.y * 0.05);
            missilePositions.add(new Vector2d(position.x, position.y));
            time += 0.05;
        }
        return missilePositions;
    }

    private static boolean isValidTrajectory(LaunchConfig launchConfig, double newAngle, double newThrustDuration) {
        List<Vector2d> positions = TrajectoryHelper.simulate(launchConfig, newAngle, newThrustDuration);
        Vector2d finalPos = positions.get(positions.size() - 1);
        return finalPos.distance((Vector2dc)new Vector2d(launchConfig.targetX, (double)(launchConfig.target.m_123342_() - launchConfig.source.m_123342_()))) <= 1.0;
    }

    public static LaunchSolution findMinLaunchSolution(LaunchConfig launchConfig) {
        double[] angleRange = TrajectoryHelper.generateRange(launchConfig.angleRange[1], launchConfig.angleRange[0], 90);
        double[] thrustDurationRange = TrajectoryHelper.generateRange(0.0, launchConfig.missileConfig.maxThrustDuration, (int)(5.0 * launchConfig.missileConfig.maxThrustDuration));
        for (int i = 1; i < thrustDurationRange.length - 1; ++i) {
            for (double angle : angleRange) {
                double low = thrustDurationRange[i - 1];
                double high = thrustDurationRange[i + 1];
                for (int j = 0; j < 5; ++j) {
                    double mid = (low + high) / 2.0;
                    if (TrajectoryHelper.isValidTrajectory(launchConfig, angle, mid)) {
                        return new LaunchSolution(mid, angle);
                    }
                    List<Vector2d> positions = TrajectoryHelper.simulate(launchConfig, angle, mid);
                    double x = positions.get((int)(positions.size() - 1)).x;
                    if (x < launchConfig.targetX) {
                        low = mid;
                        continue;
                    }
                    high = mid;
                }
            }
        }
        return null;
    }

    public static double findLaunchAngle(LaunchConfig launchConfig, double thrustDuration) {
        double low = launchConfig.angleRange[0];
        double high = launchConfig.angleRange[1];
        for (int i = 0; i < 50; ++i) {
            double mid = (low + high) / 2.0;
            if (TrajectoryHelper.isValidTrajectory(launchConfig, mid, thrustDuration)) {
                return mid;
            }
            List<Vector2d> positions = TrajectoryHelper.simulate(launchConfig, mid, thrustDuration);
            double x = positions.get((int)(positions.size() - 1)).x;
            if (x > launchConfig.targetX) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return (low + high) / 2.0;
    }

    private static int getSign(double val) {
        return val >= 0.0 ? 1 : -1;
    }

    public static class LaunchConfig {
        public BlockPos source;
        public BlockPos target;
        public double[] angleRange;
        public MissileConfig missileConfig;
        public double targetX;
        public double selectedThrustDuration;

        public LaunchConfig(BlockPos source, BlockPos target, double[] angleRange, double selectedThrustDuration, MissileConfig missileConfig) {
            this.source = source;
            this.target = target;
            this.angleRange = angleRange;
            this.missileConfig = missileConfig;
            this.targetX = Vector3d.distance((double)target.m_123341_(), (double)0.0, (double)target.m_123343_(), (double)source.m_123341_(), (double)0.0, (double)source.m_123343_());
            this.selectedThrustDuration = selectedThrustDuration;
        }
    }

    public static class MissileConfig {
        public double thrust;
        public double mass;
        public double maxThrustDuration;

        public MissileConfig(ThrusterType thruster, ChassisType chassis, WarheadType warhead) {
            this.thrust = thruster.getThrust();
            this.mass = thruster.getMass() + chassis.getMass() + warhead.getMass();
            this.maxThrustDuration = chassis.getFuelCapacity() / thruster.getBurnRate();
        }
    }

    public static class LaunchSolution {
        public final double thrustDuration;
        public final double angle;

        public LaunchSolution(double thrustDuration, double angle) {
            this.thrustDuration = thrustDuration;
            this.angle = angle;
        }
    }
}

