/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.registry.RecipeSerializers;
import org.jetbrains.annotations.NotNull;

public class AssemblyCloningRecipe
extends CustomRecipe {
    public AssemblyCloningRecipe(ResourceLocation resourceLocation, CraftingBookCategory craftingBookCategory) {
        super(resourceLocation, craftingBookCategory);
    }

    private boolean isAssembly(ItemStack stack) {
        return stack.m_150930_((Item)net.woukie.createmissiles.registry.Items.WARHEAD_ASSEMBLY.get()) || stack.m_150930_((Item)net.woukie.createmissiles.registry.Items.CHASSIS_ASSEMBLY.get()) || stack.m_150930_((Item)net.woukie.createmissiles.registry.Items.THRUSTER_ASSEMBLY.get());
    }

    public boolean matches(CraftingContainer craftingContainer, @NotNull Level level) {
        int paperCount = 0;
        ItemStack assembly = ItemStack.f_41583_;
        for (int j = 0; j < craftingContainer.m_6643_(); ++j) {
            ItemStack containerItem = craftingContainer.m_8020_(j);
            if (containerItem.m_41619_()) continue;
            if (this.isAssembly(containerItem)) {
                if (!assembly.m_41619_()) {
                    return false;
                }
                assembly = containerItem;
                continue;
            }
            if (!containerItem.m_150930_(Items.f_42516_)) {
                return false;
            }
            ++paperCount;
        }
        return !assembly.m_41619_() && paperCount > 0;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craftingContainer, @NotNull RegistryAccess registryAccess) {
        int paperCount = 0;
        ItemStack assembly = ItemStack.f_41583_;
        for (int j = 0; j < craftingContainer.m_6643_(); ++j) {
            ItemStack containerItem = craftingContainer.m_8020_(j);
            if (containerItem.m_41619_()) continue;
            if (this.isAssembly(containerItem)) {
                if (!assembly.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                assembly = containerItem;
                continue;
            }
            if (!containerItem.m_150930_(Items.f_42516_)) {
                return ItemStack.f_41583_;
            }
            ++paperCount;
        }
        if (!assembly.m_41619_() && paperCount >= 1) {
            return assembly.m_255036_(paperCount + 1);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return i >= 3 && j >= 3;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.ASSEMBLY_CLONING.get();
    }
}

