/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.registry.PartTypes;
import net.woukie.createmissiles.registry.RecipeSerializers;
import net.woukie.createmissiles.registry.RecipeTypes;
import org.jetbrains.annotations.NotNull;

public class MissilePartRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<MissileIngredient> ingredients;
    private final ResourceLocation assembly;

    public MissilePartRecipe(ResourceLocation id, NonNullList<MissileIngredient> ingredients, ResourceLocation assembly) {
        this.id = id;
        this.ingredients = ingredients;
        this.assembly = assembly;
    }

    public ResourceLocation getAssembly() {
        return this.assembly;
    }

    public boolean itemComplements(ItemStack itemStack, Container container) {
        ArrayList<ItemStack> stacksLeft = new ArrayList<ItemStack>();
        MissilePartType partType = PartTypes.get(this.assembly);
        for (int i = partType.getStartSlot(); i < partType.getEndSlot(); ++i) {
            if (container.m_8020_(i).m_41619_()) continue;
            stacksLeft.add(container.m_8020_(i));
        }
        Map<MissileIngredient, Integer> remainingItems = this.getRemainingItems(stacksLeft);
        for (Map.Entry<MissileIngredient, Integer> item : remainingItems.entrySet()) {
            if (!item.getKey().test(itemStack) || item.getValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public NonNullList<MissileIngredient> getMissileIngredients() {
        return this.ingredients;
    }

    public Map<MissileIngredient, Integer> getRemainingItems(List<ItemStack> items) {
        Map<MissileIngredient, Integer> ingredientStatus = this.getMissileIngredients().stream().collect(Collectors.toMap(a -> a, MissileIngredient::count));
        block0: for (ItemStack item : items) {
            int itemsRemaining = item.m_41613_();
            for (MissileIngredient ingredient : ingredientStatus.keySet()) {
                Integer count = ingredientStatus.get(ingredient);
                if (ingredient.test(item)) {
                    int reducedTo = Math.max(count - itemsRemaining, 0);
                    ingredientStatus.put(ingredient, reducedTo);
                    itemsRemaining -= count - reducedTo;
                }
                if (itemsRemaining != 0) continue;
                continue block0;
            }
        }
        return ingredientStatus;
    }

    public static Optional<MissilePartRecipe> fromResourceLocation(Level level, ResourceLocation resourceLocation) {
        if (level == null) {
            return Optional.empty();
        }
        List missilePartRecipes = level.m_7465_().m_44013_((RecipeType)RecipeTypes.MISSILE_PART.get());
        return missilePartRecipes.stream().filter(r -> r.getAssembly().equals((Object)resourceLocation)).findFirst();
    }

    public static Map<MissileIngredient, Integer> getRemainingItems(MissilePartType partType, Level level, List<ItemStack> items) {
        if (partType == null) {
            return null;
        }
        Optional<MissilePartRecipe> recipe = MissilePartRecipe.fromResourceLocation(level, partType.getResourceLocation());
        return recipe.map(missilePartRecipe -> missilePartRecipe.getRemainingItems(items.subList(partType.getStartSlot(), partType.getEndSlot()))).orElse(null);
    }

    public static int getBuildPercentage(Map<MissileIngredient, Integer> remainingItems) {
        if (remainingItems == null) {
            return 0;
        }
        int totalCount = 0;
        int fulfilled = 0;
        for (Map.Entry<MissileIngredient, Integer> entry : remainingItems.entrySet()) {
            int required = entry.getKey().count();
            totalCount += entry.getKey().count();
            fulfilled += required - entry.getValue();
        }
        return (int)((float)fulfilled / (float)totalCount * 100.0f);
    }

    public static int getBuildPercentage(MissilePartType partType, Level level, List<ItemStack> items) {
        if (partType == null || level == null) {
            return 0;
        }
        Map<MissileIngredient, Integer> remainingItems = MissilePartRecipe.getRemainingItems(partType, level, items);
        return MissilePartRecipe.getBuildPercentage(remainingItems);
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        ArrayList<ItemStack> containerStacks = new ArrayList<ItemStack>();
        MissilePartType partType = PartTypes.get(this.assembly);
        for (int i = partType.getStartSlot(); i < partType.getEndSlot(); ++i) {
            if (container.m_8020_(i).m_41619_()) continue;
            containerStacks.add(container.m_8020_(i));
        }
        Map<MissileIngredient, Integer> remainingItems = this.getRemainingItems(containerStacks);
        for (Map.Entry<MissileIngredient, Integer> remainingItem : remainingItems.entrySet()) {
            if (remainingItem.getValue() <= 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.MISSILE_PART.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.MISSILE_PART.get();
    }

    public static class Serializer
    implements RecipeSerializer<MissilePartRecipe> {
        @NotNull
        public MissilePartRecipe fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            NonNullList<MissileIngredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            ResourceLocation assembly = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"assembly"));
            return new MissilePartRecipe(resourceLocation, ingredients, assembly);
        }

        private static NonNullList<MissileIngredient> itemsFromJson(JsonArray jsonArray) {
            NonNullList items = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                MissileIngredient ingredient = MissileIngredient.fromJson(jsonArray.get(i), false);
                if (ingredient.isEmpty()) continue;
                items.add((Object)ingredient);
            }
            return items;
        }

        @NotNull
        public MissilePartRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            int ingredientCount = friendlyByteBuf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)MissileIngredient.EMPTY);
            ingredients.replaceAll(ignored -> MissileIngredient.fromNetwork(friendlyByteBuf));
            ResourceLocation assembly = friendlyByteBuf.m_130281_();
            return new MissilePartRecipe(resourceLocation, (NonNullList<MissileIngredient>)ingredients, assembly);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, MissilePartRecipe recipe) {
            friendlyByteBuf.m_130130_(recipe.ingredients.size());
            for (MissileIngredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(friendlyByteBuf);
            }
            friendlyByteBuf.m_130085_(recipe.assembly);
        }
    }
}

