/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.registry.RecipeSerializers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtShapedRecipe
extends ShapedRecipe {
    public NbtShapedRecipe(ResourceLocation resourceLocation, String string, CraftingBookCategory craftingBookCategory, int i, int j, NonNullList<Ingredient> nonNullList, ItemStack itemStack, boolean bl) {
        super(resourceLocation, string, craftingBookCategory, i, j, nonNullList, itemStack, bl);
    }

    public NbtShapedRecipe(ResourceLocation resourceLocation, String string, CraftingBookCategory craftingBookCategory, int i, int j, NonNullList<Ingredient> nonNullList, ItemStack itemStack) {
        super(resourceLocation, string, craftingBookCategory, i, j, nonNullList, itemStack);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.NBT_CRAFTING_SHAPED.get();
    }

    private List<NbtIngredient> getNbtIngredients() {
        NonNullList ingredients = this.m_7527_();
        return ingredients.stream().map(ingredient -> NbtIngredient.fromSuper(ingredient)).toList();
    }

    private boolean matches(CraftingContainer craftingContainer, int i, int j, boolean bl) {
        for (int k = 0; k < craftingContainer.m_39347_(); ++k) {
            for (int l = 0; l < craftingContainer.m_39346_(); ++l) {
                int m = k - i;
                int n = l - j;
                NbtIngredient ingredient = NbtIngredient.EMPTY;
                if (m >= 0 && n >= 0 && m < this.m_44220_() && n < this.m_44221_()) {
                    ingredient = bl ? this.getNbtIngredients().get(this.m_44220_() - m - 1 + n * this.m_44220_()) : this.getNbtIngredients().get(m + n * this.m_44220_());
                }
                if (ingredient.test(craftingContainer.m_8020_(k + l * craftingContainer.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_5818_(CraftingContainer craftingContainer, Level level) {
        for (int i = 0; i <= craftingContainer.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= craftingContainer.m_39346_() - this.m_44221_(); ++j) {
                if (this.matches(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    static String[] patternFromJson(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] strings, Map<String, Ingredient> map, int i, int j) {
        NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(map.keySet());
        set.remove(" ");
        for (int k = 0; k < strings.length; ++k) {
            for (int l = 0; l < strings[k].length(); ++l) {
                String string = strings[k].substring(l, l + 1);
                Ingredient ingredient = map.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(l + i * k, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonNullList;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            Ingredient i = NbtIngredient.fromJson((JsonElement)entry.getValue(), false);
            map.put((String)entry.getKey(), i);
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    static String[] shrink(String ... strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < strings.length; ++m) {
            String string = strings[m];
            i = Math.min(i, NbtShapedRecipe.firstNonSpace(string));
            int n = NbtShapedRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] strings2 = new String[strings.length - l - k];
        for (int o = 0; o < strings2.length; ++o) {
            strings2[o] = strings[o + k].substring(i, j + 1);
        }
        return strings2;
    }

    private static int firstNonSpace(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static class NbtIngredient
    extends Ingredient {
        public static final NbtIngredient EMPTY = new NbtIngredient(Stream.empty());

        public static NbtIngredient fromSuper(Ingredient ingredient) {
            return new NbtIngredient(Arrays.stream(ingredient.f_43902_));
        }

        public boolean test(@Nullable ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            if (this.m_43947_()) {
                return itemStack.m_41619_();
            }
            for (ItemStack requiredItem : this.m_43908_()) {
                boolean requireTag = requiredItem.m_41782_();
                if (!requiredItem.m_150930_(itemStack.m_41720_()) || requireTag && !requiredItem.m_41783_().equals((Object)itemStack.m_41783_())) continue;
                return true;
            }
            return false;
        }

        public NbtIngredient(Stream<? extends Ingredient.Value> stream) {
            super(stream);
        }

        public static Ingredient.Value valueFromJson(JsonObject jsonObject) {
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
            }
            if (jsonObject.has("item")) {
                return new Ingredient.ItemValue(NbtShapedRecipe.m_151274_((JsonObject)jsonObject));
            }
            if (jsonObject.has("tag")) {
                ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
                return new TagValue((TagKey<Item>)tagKey);
            }
            throw new JsonParseException("An ingredient entry needs either a tag or an item");
        }

        public static Ingredient fromJson(@Nullable JsonElement jsonElement, boolean bl) {
            if (jsonElement != null && !jsonElement.isJsonNull()) {
                if (jsonElement.isJsonObject()) {
                    return NbtIngredient.m_43938_(Stream.of(NbtIngredient.valueFromJson(jsonElement.getAsJsonObject())));
                }
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    if (jsonArray.size() == 0 && !bl) {
                        throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                    }
                    return NbtIngredient.m_43938_(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElementx -> NbtIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)jsonElementx, (String)"item"))));
                }
                throw new JsonSyntaxException("Expected item to be object or array of objects");
            }
            throw new JsonSyntaxException("Item cannot be null");
        }

        public static class TagValue
        implements Ingredient.Value {
            private final TagKey<Item> tag;

            TagValue(TagKey<Item> tagKey) {
                this.tag = tagKey;
            }

            public Collection<ItemStack> m_6223_() {
                ArrayList list = Lists.newArrayList();
                for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tag)) {
                    list.add(new ItemStack(holder));
                }
                return list;
            }

            public JsonObject m_6544_() {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("tag", this.tag.f_203868_().toString());
                return jsonObject;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<NbtShapedRecipe> {
        public NbtShapedRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> keys = NbtShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key"));
            String[] strings = NbtShapedRecipe.shrink(NbtShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pattern")));
            int width = strings[0].length();
            int height = strings.length;
            NonNullList<Ingredient> ingredients = NbtShapedRecipe.dissolvePattern(strings, keys, width, height);
            ItemStack result = NbtShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            boolean notify = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"show_notification", (boolean)true);
            return new NbtShapedRecipe(resourceLocation, group, craftingBookCategory, width, height, ingredients, result, notify);
        }

        public NbtShapedRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            int i = friendlyByteBuf.m_130242_();
            int j = friendlyByteBuf.m_130242_();
            String string = friendlyByteBuf.m_130277_();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.m_130066_(CraftingBookCategory.class);
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            boolean bl = friendlyByteBuf.readBoolean();
            return new NbtShapedRecipe(resourceLocation, string, craftingBookCategory, i, j, (NonNullList<Ingredient>)nonNullList, itemStack, bl);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, NbtShapedRecipe recipe) {
            friendlyByteBuf.m_130130_(recipe.m_44220_());
            friendlyByteBuf.m_130130_(recipe.m_44221_());
            friendlyByteBuf.m_130070_(recipe.m_6076_());
            friendlyByteBuf.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130055_(recipe.m_8043_(null));
            friendlyByteBuf.writeBoolean(recipe.m_271738_());
        }
    }
}

