/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_746;

public class FlashHandler {
    private static final ConcurrentLinkedQueue<Flash> flashes = new ConcurrentLinkedQueue();

    public static void addFlash(Flash flash) {
        flashes.add(flash);
    }

    public static void cleanUp() {
        flashes.removeIf(flash -> ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length > 1.0);
    }

    public static void handleHudRender(class_332 guiGraphics) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 position = player.method_19538();
        flashes.forEach(flash -> {
            double timeIntensity = ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length;
            if (timeIntensity >= 1.0) {
                return;
            }
            timeIntensity = Math.pow(1.0 - timeIntensity, 3.0);
            double distance = position.method_1022(flash.origin.method_46558());
            distance = Math.min(distance / (double)flash.radius.intValue(), 1.0);
            double distanceIntensity = Math.pow(1.0 - distance, 3.0);
            int colour = class_5253.class_5254.method_27764((int)((int)(255.0 * distanceIntensity * timeIntensity)), (int)class_5253.class_5254.method_27765((int)flash.colour), (int)class_5253.class_5254.method_27766((int)flash.colour), (int)class_5253.class_5254.method_27767((int)flash.colour));
            guiGraphics.method_25294(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), colour);
        });
    }

    public static void handleRenderLevel(class_4587 poseStack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 position = player.method_19538();
        for (Flash flash : flashes) {
            double timeIntensity = ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length;
            double shakeIndex = timeIntensity * (double)(flash.shakeSamples.size() - 2);
            if (timeIntensity >= 1.0) continue;
            timeIntensity = Math.pow(1.0 - timeIntensity, 3.0);
            class_243 shake1 = flash.shakeSamples.get((int)shakeIndex);
            class_243 shake2 = flash.shakeSamples.get((int)shakeIndex + 1);
            class_243 shake = shake1.method_35590(shake2, shakeIndex % 1.0);
            double distance = position.method_1022(flash.origin.method_46558());
            distance = Math.min(distance / (double)flash.radius.intValue(), 1.0);
            double intensity = Math.pow(1.0 - distance, 3.0);
            double scaledIntensity = Math.pow(-(flash.intensity / 4.0 + 1.0), -1.0) + 1.0;
            shake = shake.method_1021(timeIntensity * intensity * scaledIntensity * 3.0);
            poseStack.method_22904(shake.field_1352, shake.field_1351, shake.field_1350);
        }
    }

    public static class Flash {
        public class_2338 origin;
        public Integer colour;
        public Integer radius;
        public Double intensity;
        public long startTime;
        public long length;
        public List<class_243> shakeSamples = new ArrayList<class_243>();

        public Flash(Integer colour, class_2338 origin, Integer radius, Double intensity, long length) {
            this.colour = colour;
            this.origin = origin;
            this.radius = radius;
            this.intensity = intensity;
            this.startTime = System.currentTimeMillis();
            this.length = length;
            int i = 0;
            while ((long)i < 20L * length / 1000L) {
                this.shakeSamples.add(new class_243(Math.random() * 2.0 - 0.5, Math.random() * 2.0 - 0.5, Math.random() * 2.0 - 0.5));
                ++i;
            }
        }
    }
}

