/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_747;
import net.woukie.createmissiles.entity.drone.DroneHandler;
import net.woukie.createmissiles.entity.drone.MapUtils;
import net.woukie.createmissiles.inventory.DroneMenu;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Drone
extends class_1307 {
    private final class_3913 dataAccess;
    class_2338 storedMapPos;
    class_2338 targetBlock;
    class_2338 originBlock;
    protected class_1277 mapContainer;

    public Drone(class_1299<? extends Drone> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new DroneMoveControl(this, (class_1308)this);
        this.field_6206 = new EmptyLookControl(this, (class_1308)this);
        this.mapContainer = new class_1277(1);
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                int[] uuidArray = 1.uuidToShortArray(Drone.this.method_5667());
                return switch (i) {
                    case 0 -> uuidArray[0];
                    case 1 -> uuidArray[1];
                    case 2 -> uuidArray[2];
                    case 3 -> uuidArray[3];
                    case 4 -> uuidArray[4];
                    case 5 -> uuidArray[5];
                    case 6 -> uuidArray[6];
                    case 7 -> uuidArray[7];
                    case 8 -> Drone.this.method_24515().method_10263();
                    case 9 -> Drone.this.method_24515().method_10260();
                    case 10 -> {
                        if (Drone.this.targetBlock != null || Drone.this.originBlock != null) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 11 -> {
                        if (Drone.this.method_5864().equals(EntityTypes.BASIC_DRONE.get())) {
                            yield 0;
                        }
                        yield 1;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int i, int j) {
            }

            public int method_17389() {
                return 12;
            }

            private static int[] uuidToShortArray(UUID uUID) {
                long mostSig = uUID.getMostSignificantBits();
                long leastSig = uUID.getLeastSignificantBits();
                return new int[]{(int)(mostSig >> 48 & 0xFFFFL), (int)(mostSig >> 32 & 0xFFFFL), (int)(mostSig >> 16 & 0xFFFFL), (int)(mostSig & 0xFFFFL), (int)(leastSig >> 48 & 0xFFFFL), (int)(leastSig >> 32 & 0xFFFFL), (int)(leastSig >> 16 & 0xFFFFL), (int)(leastSig & 0xFFFFL)};
            }
        };
    }

    public void method_5982() {
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double d) {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            boolean i = true;
            float h = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float j = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float k = 0.135f * ((float)i * 0.2f + 1.0f);
            this.method_37908().method_8406((class_2394)class_2398.field_11219, this.method_23317() + (double)h, this.method_23318() + (double)k, this.method_23321() + (double)j, 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_11219, this.method_23317() - (double)h, this.method_23318() + (double)k, this.method_23321() - (double)j, 0.0, 0.0, 0.0);
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("StoredMapPosX")) {
            this.storedMapPos = new class_2338(compoundTag.method_10550("StoredMapPosX"), compoundTag.method_10550("StoredMapPosY"), compoundTag.method_10550("StoredMapPosZ"));
        }
        if (compoundTag.method_10545("TargetBlockX")) {
            this.targetBlock = new class_2338(compoundTag.method_10550("TargetBlockX"), compoundTag.method_10550("TargetBlockY"), compoundTag.method_10550("TargetBlockZ"));
        }
        if (compoundTag.method_10545("OriginBlockX")) {
            this.originBlock = new class_2338(compoundTag.method_10550("OriginBlockX"), compoundTag.method_10550("OriginBlockY"), compoundTag.method_10550("OriginBlockZ"));
        }
        if (compoundTag.method_10545("MapItem")) {
            this.mapContainer = new class_1277(new class_1799[]{class_1799.method_7915((class_2487)compoundTag.method_10562("MapItem"))});
        }
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.storedMapPos != null) {
            compoundTag.method_10569("StoredMapPosX", this.storedMapPos.method_10263());
            compoundTag.method_10569("StoredMapPosY", this.storedMapPos.method_10264());
            compoundTag.method_10569("StoredMapPosZ", this.storedMapPos.method_10260());
        }
        if (this.targetBlock != null) {
            compoundTag.method_10569("TargetBlockX", this.targetBlock.method_10263());
            compoundTag.method_10569("TargetBlockY", this.targetBlock.method_10264());
            compoundTag.method_10569("TargetBlockZ", this.targetBlock.method_10260());
        }
        if (this.originBlock != null) {
            compoundTag.method_10569("OriginBlockX", this.originBlock.method_10263());
            compoundTag.method_10569("OriginBlockY", this.originBlock.method_10264());
            compoundTag.method_10569("OriginBlockZ", this.originBlock.method_10260());
        }
        compoundTag.method_10566("MapItem", (class_2520)this.mapContainer.method_5438(0).method_7953(new class_2487()));
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15149;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14974;
    }

    public class_3419 method_5634() {
        return class_3419.field_15248;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14813;
    }

    protected boolean method_23734() {
        return false;
    }

    protected float method_18394(@NotNull class_4050 pose, class_4048 entityDimensions) {
        return entityDimensions.field_18068 * 0.35f;
    }

    public boolean method_5732() {
        return true;
    }

    public void method_6007() {
        if (this.method_5805() && this.method_5972()) {
            this.method_5639(8);
        }
        super.method_6007();
    }

    public boolean method_31747() {
        return true;
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        class_1297 entity = damageSource.method_5529();
        if (!this.method_37908().method_8608() && entity != null && entity.method_5864().equals(class_1299.field_6097)) {
            this.method_37908().method_45447(null, this.method_24515(), class_3417.field_16509, class_3419.field_15254);
            this.popMap((class_3218)this.method_37908());
            this.dropItem();
            this.method_31472();
            return true;
        }
        return super.method_5643(damageSource, f);
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().field_9236) {
            this.popMap((class_3218)this.method_37908());
            DroneHandler.get().stopTrackingDrone((class_3218)this.method_37908(), this.method_5667());
        }
        super.method_6078(damageSource);
    }

    public void popMap(class_3218 level) {
        if (this.storedMapPos != null) {
            MapUtils.spawnMapAt(level, this.method_19538().method_1031(0.0, 0.5, 0.0), this.storedMapPos);
            level.method_43128(null, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, class_3417.field_17484, class_3419.field_15248, 1.0f, 1.0f);
            this.storedMapPos = null;
        } else {
            class_2347.method_10134((class_1937)this.method_37908(), (class_1799)this.mapContainer.method_5438(0), (int)1, (class_2350)class_2350.field_11036, (class_2374)this.method_19538());
        }
        this.mapContainer.method_5448();
    }

    protected void dropItem() {
        class_2347.method_10134((class_1937)this.method_37908(), (class_1799)new class_1799((class_1935)Items.DRONE_BOX_ITEM.get()), (int)1, (class_2350)class_2350.field_11036, (class_2374)this.method_19538());
    }

    public boolean method_5863() {
        return true;
    }

    @Nullable
    public class_1799 method_31480() {
        return ((class_1792)Items.DRONE_BOX_ITEM.get()).method_7854();
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        if (this.storedMapPos != null) {
            this.popMap((class_3218)this.method_37908());
            return class_1269.field_5812;
        }
        if (this.targetBlock != null || this.originBlock != null) {
            return class_1269.field_5814;
        }
        if (!this.method_37908().field_9236) {
            player.method_17355((class_3908)new class_747((ix, inventory, playerx) -> new DroneMenu(ix, inventory, this.dataAccess, (class_1263)this.mapContainer), this.method_5476()));
        }
        return class_1269.field_5812;
    }

    public void startMission(class_2338 destination) {
        if (this.mapContainer.method_5438(0).method_7960()) {
            return;
        }
        this.method_37908().method_43128(null, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        this.targetBlock = destination;
        this.originBlock = this.method_24515();
        DroneHandler.get().trackDrone(this);
    }

    protected class_1330 method_5963() {
        return new DroneBodyRotationControl(this, (class_1308)this);
    }

    public class DroneMoveControl
    extends class_1335 {
        private boolean hasOigin;
        private boolean hasTarget;

        public DroneMoveControl(Drone drone, class_1308 mob) {
            super(mob);
        }

        public void method_6240() {
            Vector2i originPos;
            Vector2i targetPos;
            if (Drone.this.field_5976) {
                Drone.this.method_36456(Drone.this.method_36454() + 180.0f);
            }
            this.updateTargetStatus();
            this.tickTravelOrWait();
            Vector2i currentPos = new Vector2i(Drone.this.method_24515().method_10263(), Drone.this.method_24515().method_10260());
            if (this.hasTarget && (targetPos = new Vector2i(Drone.this.targetBlock.method_10263(), Drone.this.targetBlock.method_10260())).distance((Vector2ic)currentPos) < 25.0) {
                Drone.this.storedMapPos = Drone.this.targetBlock;
                Drone.this.targetBlock = null;
            }
            if (!this.hasTarget && this.hasOigin && (originPos = new Vector2i(Drone.this.originBlock.method_10263(), Drone.this.originBlock.method_10260())).distance((Vector2ic)currentPos) < 3.0) {
                DroneHandler.get().stopTrackingDrone((class_3218)Drone.this.method_37908(), Drone.this.field_6021);
                Drone.this.originBlock = null;
            }
        }

        private void tickTravelOrWait() {
            if (this.hasTarget) {
                this.tickTravel(Drone.this.targetBlock);
            } else if (this.hasOigin) {
                this.tickTravel(Drone.this.originBlock);
            } else {
                this.tickWait();
            }
            this.updateTargetStatus();
        }

        private void updateTargetStatus() {
            this.hasOigin = Drone.this.originBlock != null;
            boolean bl = this.hasTarget = Drone.this.targetBlock != null;
            if (this.hasTarget && !this.hasOigin) {
                Drone.this.originBlock = Drone.this.targetBlock;
            }
        }

        private void tickWait() {
            if (!Drone.this.method_24828()) {
                Drone.this.method_18799(Drone.this.method_18798().method_1031(0.0, -0.24, 0.0));
                Drone.this.method_36457(class_3532.method_15388((float)Drone.this.method_36455(), (float)70.0f, (float)4.0f));
            } else {
                Drone.this.method_36457(0.0f);
            }
        }

        private void tickTravel(class_2338 destination) {
            double dZ;
            double dX = (double)destination.method_10263() - Drone.this.method_23317();
            double distance = Math.sqrt(dX * dX + (dZ = (double)destination.method_10260() - Drone.this.method_23321()) * dZ);
            if (Math.abs(distance) > (double)1.0E-5f) {
                float yTurnSpeed = 1.0f;
                if (distance < 30.0) {
                    yTurnSpeed = 10.0f;
                }
                float angle = (float)class_3532.method_15349((double)dZ, (double)dX);
                float currentYRot = class_3532.method_15393((float)(Drone.this.method_36454() + 90.0f));
                float targetYRot = class_3532.method_15393((float)(angle * 57.295776f));
                Drone.this.method_36456(class_3532.method_15388((float)currentYRot, (float)targetYRot, (float)yTurnSpeed) - 90.0f);
                Drone.this.field_6283 = Drone.this.method_36454();
                float targetXRot = 0.0f;
                for (int i = 0; i < 50; ++i) {
                    if (!Drone.this.method_37908().method_22347(Drone.this.method_24515().method_10087(i))) {
                        targetXRot = -70.0f;
                        break;
                    }
                    if (Drone.this.method_37908().method_22347(Drone.this.method_24515().method_10086(i))) continue;
                    targetXRot = 70.0f;
                    break;
                }
                Drone.this.method_36457(class_3532.method_15388((float)Drone.this.method_36455(), (float)targetXRot, (float)1.0f));
                float pitch = Drone.this.method_36455() * (float)Math.PI / 180.0f;
                float yaw = Drone.this.method_36454() * (float)Math.PI / 180.0f;
                double x = -Math.sin(yaw) * Math.cos(pitch);
                double y = -Math.sin(pitch);
                double z = Math.cos(yaw) * Math.cos(pitch);
                class_243 directionVector = new class_243(x, y, z);
                class_243 vec3 = Drone.this.method_18798();
                Drone.this.method_18799(vec3.method_1019(directionVector.method_1020(vec3).method_1021(0.2)));
            }
        }
    }

    public static class EmptyLookControl
    extends class_1333 {
        public EmptyLookControl(Drone drone, class_1308 mob) {
            super(mob);
        }

        public void method_6231() {
        }
    }

    class DroneBodyRotationControl
    extends class_1330 {
        public DroneBodyRotationControl(Drone drone, class_1308 mob) {
            super(mob);
        }

        public void method_6224() {
            Drone.this.field_6241 = Drone.this.field_6283;
            Drone.this.field_6283 = Drone.this.method_36454();
        }
    }
}

