/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_18;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.entity.drone.Drone;
import org.jetbrains.annotations.NotNull;

public class DroneHandler
extends class_18 {
    private static WorldAttached<HashMap<UUID, class_2487>> drones = new WorldAttached<HashMap<UUID, class_2487>>(l -> new HashMap()){};
    private static HashMap<UUID, class_1297> entityCache = new HashMap();
    private static Set<UUID> killEntityWhenever = new HashSet<UUID>();
    private static Set<UUID> stopTrackingNextTick = new HashSet<UUID>();
    private static MinecraftServer server;
    private static DroneHandler instance;
    private static boolean initialized;
    private static boolean destroyOnSave;

    private DroneHandler() {
    }

    public static DroneHandler get() {
        if (instance == null) {
            instance = new DroneHandler();
        }
        return instance;
    }

    public void trackDrone(Drone drone) {
        ((HashMap)drones.get((class_1936)drone.method_37908())).put(drone.method_5667(), drone.method_5647(new class_2487()));
        this.method_80();
    }

    public void stopTrackingDrone(class_3218 level, UUID uuid) {
        ((HashMap)drones.get((class_1936)level)).remove(uuid);
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.method_80();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        server.method_3738().forEach(serverLevel -> {
            killEntityWhenever.removeIf(uuid -> {
                class_1297 e = serverLevel.method_14190(uuid);
                if (e != null) {
                    e.method_31472();
                    entityCache.remove(e.method_5667());
                    return true;
                }
                return false;
            });
            stopTrackingNextTick.forEach(uuid -> this.stopTrackingDrone((class_3218)serverLevel, (UUID)uuid));
            ArrayList changedUUID = new ArrayList();
            ((HashMap)drones.get((class_1936)serverLevel)).forEach((uuid, tag) -> {
                if (this.tickDrone((class_3218)serverLevel, (UUID)uuid, (class_2487)tag)) {
                    changedUUID.add(uuid);
                }
            });
            changedUUID.forEach(uuid -> {
                HashMap levelData = (HashMap)drones.get((class_1936)serverLevel);
                class_2487 data = (class_2487)levelData.get(uuid);
                levelData.remove(uuid);
                levelData.put(data.method_25926("UUID"), data);
            });
        });
    }

    private boolean tickDrone(class_3218 level, UUID uuid, class_2487 drone) {
        boolean ticking;
        class_1297 entity = entityCache.computeIfAbsent(uuid, uuid1 -> level.method_14190(uuid));
        boolean entityLoaded = entity != null;
        boolean bl = ticking = entityLoaded && level.method_37118(entity.method_24515());
        if (ticking) {
            class_2487 updatedData = entity.method_5647(new class_2487());
            updatedData.method_10556("Simulated", false);
            updatedData.method_10582("id", class_1299.method_5890((class_1299)entity.method_5864()).toString());
            ((HashMap)drones.get((class_1936)level)).put(uuid, updatedData);
            return false;
        }
        if (entityLoaded || !drone.method_10545("Simulated") || !drone.method_10577("Simulated")) {
            killEntityWhenever.add(drone.method_25926("UUID"));
            entityCache.remove(uuid);
            drone.method_25927("UUID", UUID.randomUUID());
            drone.method_10556("Simulated", true);
            return true;
        }
        DroneHandler.simulateDroneMovement(drone);
        if (DroneHandler.shouldBeReal(level, drone)) {
            DroneHandler.makeReal(level, drone);
        }
        return false;
    }

    private static boolean shouldBeReal(class_3218 level, class_2487 drone) {
        class_2499 posList = drone.method_10554("Pos", 6);
        class_2338 currentBlockPosition = class_2338.method_49638((class_2374)new class_243(posList.method_10611(0), posList.method_10611(1), posList.method_10611(2)));
        return drone.method_10545("Simulated") && drone.method_10577("Simulated") && level.method_8477(currentBlockPosition) && level.method_37118(currentBlockPosition);
    }

    private static void makeReal(class_3218 level, class_2487 drone) {
        class_2499 posList = drone.method_10554("Pos", 6);
        class_243 currentPosition = new class_243(posList.method_10611(0), posList.method_10611(1), posList.method_10611(2));
        class_2338 target = null;
        if (drone.method_10545("TargetBlockX")) {
            target = new class_2338(drone.method_10550("TargetBlockX"), drone.method_10550("TargetBlockY"), drone.method_10550("TargetBlockZ"));
        } else if (drone.method_10545("OriginBlockX")) {
            target = new class_2338(drone.method_10550("OriginBlockX"), drone.method_10550("OriginBlockY"), drone.method_10550("OriginBlockZ"));
        }
        class_1299 entityType = (class_1299)class_1299.method_17684((class_2487)drone).get();
        class_1297 entity = entityType.method_5883((class_1937)level);
        entity.method_5651(drone);
        entity.method_5826(drone.method_25926("UUID"));
        if (target != null) {
            double dX = (double)target.method_10263() - currentPosition.field_1352;
            double dZ = (double)target.method_10260() - currentPosition.field_1350;
            float angle = (float)class_3532.method_15349((double)dZ, (double)dX);
            float targetYRot = class_3532.method_15393((float)(angle * 57.295776f));
            entity.method_36456(targetYRot - 90.0f);
            entity.method_5636(entity.method_36454());
        }
        level.method_8649(entity);
        entityCache.put(drone.method_25926("UUID"), entity);
        entity.method_33574(DroneHandler.getAdjustedLoadPosition(level, currentPosition));
    }

    private static void simulateDroneMovement(class_2487 drone) {
        class_2338 currentTarget;
        class_2338 originBlock = null;
        class_2338 targetBlock = null;
        if (drone.method_10545("OriginBlockX")) {
            originBlock = new class_2338(drone.method_10550("OriginBlockX"), drone.method_10550("OriginBlockY"), drone.method_10550("OriginBlockZ"));
        }
        if (drone.method_10545("TargetBlockX")) {
            targetBlock = new class_2338(drone.method_10550("TargetBlockX"), drone.method_10550("TargetBlockY"), drone.method_10550("TargetBlockZ"));
        }
        class_2499 posList = drone.method_10554("Pos", 6);
        class_243 currentPosition = new class_243(posList.method_10611(0), posList.method_10611(1), posList.method_10611(2));
        class_2338 class_23382 = currentTarget = targetBlock != null ? targetBlock : originBlock;
        if (currentTarget == null) {
            stopTrackingNextTick.add(drone.method_25926("UUID"));
            return;
        }
        class_243 flatTarget = currentTarget.method_46558().method_18805(1.0, 0.0, 1.0);
        class_243 flatPosition = currentPosition.method_18805(1.0, 0.0, 1.0);
        float speed = 2.4f;
        class_243 delta = flatTarget.method_1020(flatPosition).method_1029().method_1021((double)speed);
        currentPosition = currentPosition.method_1019(delta);
        drone.method_10566("Pos", (class_2520)DroneHandler.newDoubleList(currentPosition.field_1352, currentPosition.field_1351, currentPosition.field_1350));
        if (targetBlock != null && flatPosition.method_1022(targetBlock.method_46558().method_18805(1.0, 0.0, 1.0)) < 5.0) {
            drone.method_10569("StoredMapPosX", targetBlock.method_10263());
            drone.method_10569("StoredMapPosY", targetBlock.method_10264());
            drone.method_10569("StoredMapPosZ", targetBlock.method_10260());
            drone.method_10551("TargetBlockX");
            drone.method_10551("TargetBlockY");
            drone.method_10551("TargetBlockZ");
        }
        if (originBlock != null && flatPosition.method_1022(originBlock.method_46558().method_18805(1.0, 0.0, 1.0)) < 5.0) {
            drone.method_10551("OriginBlockX");
            drone.method_10551("OriginBlockY");
            drone.method_10551("OriginBlockZ");
        }
    }

    private static class_2499 newDoubleList(double ... ds) {
        class_2499 listTag = new class_2499();
        for (double d : ds) {
            listTag.add((Object)class_2489.method_23241((double)d));
        }
        return listTag;
    }

    private static class_243 getAdjustedLoadPosition(class_3218 level, class_243 position) {
        int upper = 0;
        int lower = 0;
        boolean hitUpper = false;
        boolean hitLower = false;
        for (int i = 0; !(i >= 50 || hitLower && hitUpper); ++i) {
            if (!hitUpper) {
                if (level.method_22347(class_2338.method_49638((class_2374)position.method_43206(class_2350.field_11036, (double)i)))) {
                    upper = i;
                } else {
                    hitUpper = true;
                }
            }
            if (hitLower) continue;
            if (level.method_22347(class_2338.method_49638((class_2374)position.method_43206(class_2350.field_11036, (double)(-i))))) {
                lower = -i;
                continue;
            }
            hitLower = true;
        }
        return position.method_43206(class_2350.field_11036, (double)((float)(upper + lower) / 2.0f));
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        DroneHandler.server = server;
        class_26 storage = server.method_30002().method_17983();
        storage.method_17924(this::load, () -> this, "Drones");
    }

    public DroneHandler load(class_2487 nbt) {
        class_2487 levels = nbt.method_10562("Drones");
        levels.method_10541().forEach(dimensionKey -> {
            class_2499 drones = levels.method_10554(dimensionKey, 10);
            class_3218 level = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimensionKey)));
            drones.forEach(arg_0 -> DroneHandler.lambda$load$8((class_1937)level, arg_0));
        });
        CreateMissiles.LOGGER.info("Drones loaded");
        class_2499 hitList = nbt.method_10554("HitList", 10);
        hitList.forEach(tag -> killEntityWhenever.add(UUID.fromString(tag.method_10714())));
        return this;
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag) {
        CreateMissiles.LOGGER.info("Saving drones");
        class_2487 data = new class_2487();
        server.method_3738().forEach(serverLevel -> {
            class_2499 droneListData = new class_2499();
            droneListData.addAll(((HashMap)drones.get((class_1936)serverLevel)).values());
            data.method_10566(serverLevel.method_27983().method_29177().method_12832(), (class_2520)droneListData);
        });
        compoundTag.method_10566("Drones", (class_2520)data);
        class_2499 hitList = new class_2499();
        hitList.addAll(killEntityWhenever.stream().map(uuid -> class_2519.method_23256((String)uuid.toString())).toList());
        compoundTag.method_10566("HitList", (class_2520)hitList);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            drones = new WorldAttached<HashMap<UUID, class_2487>>(l -> new HashMap()){};
            entityCache = new HashMap();
            killEntityWhenever = new HashSet<UUID>();
            stopTrackingNextTick = new HashSet<UUID>();
            server = null;
            instance = null;
        }
        return compoundTag;
    }

    private static /* synthetic */ void lambda$load$8(class_1937 level, class_2520 tag) {
        class_2487 drone = (class_2487)tag;
        ((HashMap)drones.get((class_1936)level)).put(drone.method_25926("UUID"), drone);
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

