/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;

public class Trajectories
extends class_18 {
    private final List<Trajectory> activeTrajectories = new ArrayList<Trajectory>();
    private final HashMap<UUID, class_1297> entityCache = new HashMap();
    private final List<UUID> killEntityWhenever = new ArrayList<UUID>();
    private static Trajectories instance;
    private static boolean initialized;
    private static boolean destroyOnSave;
    private static MinecraftServer server;

    private Trajectories() {
    }

    public static Trajectories get() {
        if (instance == null) {
            instance = new Trajectories();
        }
        return instance;
    }

    public void init(MinecraftServer server) {
        if (initialized) {
            return;
        }
        initialized = true;
        Trajectories.server = server;
        class_26 storage = server.method_30002().method_17983();
        storage.method_17924(this::load, () -> this, "trajectory");
    }

    public void stop() {
        if (!initialized) {
            return;
        }
        initialized = false;
        this.method_80();
        destroyOnSave = true;
    }

    public void serverTick(MinecraftServer server) {
        this.killEntityWhenever.removeIf(uuid -> {
            Iterable levels = server.method_3738();
            Iterator iterator = levels.iterator();
            if (iterator.hasNext()) {
                class_3218 level = (class_3218)iterator.next();
                class_1297 e = level.method_14190(uuid);
                if (e == null) {
                    return false;
                }
                e.method_31472();
                this.entityCache.remove(e.method_5667());
                return true;
            }
            return false;
        });
        this.activeTrajectories.forEach(trajectory -> {
            class_3218 level = server.method_3847(trajectory.getLevelKey());
            if (level == null) {
                return;
            }
            if (trajectory.getEntityId() == null) {
                MissileEntity entity = new MissileEntity((class_1299)EntityTypes.MISSILE.get(), (class_1937)level);
                UUID uuid = UUID.randomUUID();
                entity.method_5826(uuid);
                trajectory.updateEntityModel(entity);
                trajectory.setEntityId(uuid);
                level.method_8649((class_1297)entity);
                this.entityCache.put(uuid, entity);
                this.method_80();
                return;
            }
            UUID uuid = trajectory.getEntityId();
            class_1297 entity = this.entityCache.computeIfAbsent(uuid, uuid1 -> level.method_14190(uuid));
            if (entity == null || entity.method_31481() || !entity.method_5805()) {
                this.killEntityWhenever.add(uuid);
                this.entityCache.remove(uuid);
                trajectory.setEntityId(null);
            }
            trajectory.tick();
            trajectory.warheadType.onTick((Trajectory)trajectory, server);
            trajectory.chassisType.onTick((Trajectory)trajectory, server);
            trajectory.thrusterType.onTick((Trajectory)trajectory, server);
            trajectory.updateEntityModel((MissileEntity)entity);
        });
        this.activeTrajectories.removeIf(trajectory -> {
            class_1297 entity;
            if (!trajectory.getSpent()) {
                return false;
            }
            class_3218 level = server.method_3847(trajectory.getLevelKey());
            if (level != null && (entity = level.method_14190(trajectory.getEntityId())) != null) {
                entity.method_5650(class_1297.class_5529.field_26998);
            }
            this.method_80();
            return true;
        });
    }

    public void launch(Trajectory trajectory) {
        this.activeTrajectories.add(trajectory);
    }

    public Trajectories load(class_2487 nbt) {
        class_2499 trajectories = nbt.method_10554("Trajectories", 10);
        trajectories.forEach(tag -> {
            class_2487 savedData = (class_2487)tag;
            ThrusterType thrusterType = (ThrusterType)PartTypes.get(new class_2960(savedData.method_10558("ThrusterType")));
            this.launch(thrusterType.constructTrajectory(savedData, server));
        });
        class_2499 hitList = nbt.method_10554("HitList", 10);
        this.killEntityWhenever.addAll(hitList.stream().map(tag -> UUID.fromString(tag.toString())).toList());
        CreateMissiles.LOGGER.info("Trajectories loaded");
        return this;
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag) {
        class_2499 trajectories = new class_2499();
        for (Trajectory trajectory : this.activeTrajectories) {
            CreateMissiles.LOGGER.info("Saving trajectory at {}", (Object)trajectory.position);
            trajectories.add((Object)trajectory.saveTo(new class_2487()));
        }
        class_2499 hitList = new class_2499();
        hitList.addAll(this.killEntityWhenever.stream().map(uuid -> class_2519.method_23256((String)uuid.toString())).toList());
        compoundTag.method_10566("Trajectories", (class_2520)trajectories);
        compoundTag.method_10566("HitList", (class_2520)hitList);
        if (destroyOnSave) {
            destroyOnSave = false;
            initialized = false;
            server = null;
            this.activeTrajectories.clear();
            this.entityCache.clear();
            this.killEntityWhenever.clear();
            instance = null;
        }
        return compoundTag;
    }

    static {
        initialized = false;
        destroyOnSave = false;
    }
}

