/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles;

import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.PartTypes;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public abstract class Trajectory {
    protected class_5321<class_1937> levelKey;
    protected int tick;
    protected UUID entityId;
    protected WarheadType warheadType;
    protected ChassisType chassisType;
    protected ThrusterType thrusterType;
    protected Vector3d initialPosition;
    protected Vector3d position;
    protected Vector3d targetPosition;
    protected Vector3d lastPosition;
    protected class_2487 warheadData;
    protected class_2487 chassisData;
    protected class_2487 thrusterData;
    private boolean spent;

    public Trajectory(class_5321<class_1937> levelKey, Vector3d initialPosition, Vector3d targetPosition, WarheadType warheadType, ChassisType chassisType, ThrusterType thrusterType, class_1263 container) {
        this.levelKey = levelKey;
        this.initialPosition = new Vector3d((Vector3dc)initialPosition);
        this.position = new Vector3d((Vector3dc)initialPosition);
        this.targetPosition = new Vector3d((Vector3dc)targetPosition);
        this.lastPosition = new Vector3d((Vector3dc)initialPosition);
        this.tick = 0;
        this.warheadType = warheadType;
        this.chassisType = chassisType;
        this.thrusterType = thrusterType;
        if (container != null) {
            this.warheadData = warheadType.saveTo(container, new class_2487());
            this.chassisData = chassisType.saveTo(container, new class_2487());
            this.thrusterData = thrusterType.saveTo(container, new class_2487());
        }
    }

    public Trajectory(class_2487 data, MinecraftServer server) {
        this.loadFrom(data, server);
    }

    public void tick() {
        ++this.tick;
    }

    public class_2487 saveTo(class_2487 data) {
        data.method_10582("Dimension", this.levelKey.method_29177().method_12832());
        if (this.entityId != null) {
            data.method_25927("EntityID", this.entityId);
        }
        data.method_10569("Tick", this.tick);
        data.method_10549("InitialPositionX", this.initialPosition.x);
        data.method_10549("InitialPositionY", this.initialPosition.y);
        data.method_10549("InitialPositionZ", this.initialPosition.z);
        data.method_10549("PositionX", this.position.x);
        data.method_10549("PositionY", this.position.y);
        data.method_10549("PositionZ", this.position.z);
        data.method_10549("TargetPositionX", this.targetPosition.x);
        data.method_10549("TargetPositionY", this.targetPosition.y);
        data.method_10549("TargetPositionZ", this.targetPosition.z);
        data.method_10549("LastPositionX", this.lastPosition.x);
        data.method_10549("LastPositionY", this.lastPosition.y);
        data.method_10549("LastPositionZ", this.lastPosition.z);
        data.method_10582("WarheadType", this.warheadType.getResourceLocation().toString());
        data.method_10582("ChassisType", this.chassisType.getResourceLocation().toString());
        data.method_10582("ThrusterType", this.thrusterType.getResourceLocation().toString());
        data.method_10566("WarheadData", (class_2520)this.warheadData);
        data.method_10566("ChassisData", (class_2520)this.chassisData);
        data.method_10566("ThrusterData", (class_2520)this.thrusterData);
        return data;
    }

    private void loadFrom(class_2487 data, MinecraftServer server) {
        String dimension = data.method_10558("Dimension");
        this.levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimension));
        this.entityId = data.method_25928("EntityID") ? data.method_25926("EntityID") : null;
        this.tick = data.method_10550("Tick");
        this.warheadType = (WarheadType)PartTypes.get(new class_2960(data.method_10558("WarheadType")));
        this.chassisType = (ChassisType)PartTypes.get(new class_2960(data.method_10558("ChassisType")));
        this.thrusterType = (ThrusterType)PartTypes.get(new class_2960(data.method_10558("ThrusterType")));
        this.initialPosition = new Vector3d(data.method_10574("InitialPositionX"), data.method_10574("InitialPositionY"), data.method_10574("InitialPositionZ"));
        this.position = new Vector3d(data.method_10574("PositionX"), data.method_10574("PositionY"), data.method_10574("PositionZ"));
        this.targetPosition = new Vector3d(data.method_10574("TargetPositionX"), data.method_10574("TargetPositionY"), data.method_10574("TargetPositionZ"));
        this.lastPosition = new Vector3d(data.method_10574("LastPositionX"), data.method_10574("LastPositionY"), data.method_10574("LastPositionZ"));
        this.warheadData = data.method_10562("WarheadData");
        this.chassisData = data.method_10562("ChassisData");
        this.thrusterData = data.method_10562("ThrusterData");
    }

    public void updateEntityModel(MissileEntity entity) {
        if (entity == null) {
            return;
        }
        Vector3d p = this.getPosition();
        entity.method_5814(p.x, p.y, p.z);
        entity.setWarheadBuildPercent(100);
        entity.setChassisBuildPercent(100);
        entity.setThrusterBuildPercent(100);
        entity.setWarheadType(this.warheadType.getResourceLocation());
        entity.setChassisType(this.chassisType.getResourceLocation());
        entity.setThrusterType(this.thrusterType.getResourceLocation());
        entity.setFlying(true);
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public class_5321<class_1937> getLevelKey() {
        return this.levelKey;
    }

    public WarheadType getWarheadType() {
        return this.warheadType;
    }

    public ChassisType getChassisType() {
        return this.chassisType;
    }

    public ThrusterType getThrusterType() {
        return this.thrusterType;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getTargetPosition() {
        return this.targetPosition;
    }

    public Vector3d getInitialPosition() {
        return this.initialPosition;
    }

    public Vector3d getLastPosition() {
        return this.lastPosition;
    }

    public int getTick() {
        return this.tick;
    }

    public class_2487 getWarheadData() {
        return this.warheadData;
    }

    public class_2487 getChassisData() {
        return this.chassisData;
    }

    public class_2487 getThrusterData() {
        return this.thrusterData;
    }

    public void setSpent(boolean spent) {
        this.spent = spent;
    }

    public boolean getSpent() {
        return this.spent;
    }

    public void setEntityId(UUID uuid) {
        this.entityId = uuid;
    }
}

