/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.item.BiomeVialItem;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.Items;

public class BiomeBrushWarhead
extends WarheadType {
    private final int radius = 16;

    @Override
    public float getMass() {
        return 7.5f;
    }

    @Override
    public void onDetonate(class_243 hitPosition, Trajectory trajectory, MinecraftServer server) {
        class_3218 level = server.method_3847(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        class_2382 center = new class_2382((int)hitPosition.field_1352, (int)hitPosition.field_1351, (int)hitPosition.field_1350);
        class_3341 boundingBox = class_3341.method_34390((class_2382)center.method_34592(16, 16, 16), (class_2382)center.method_34592(-16, -16, -16));
        ArrayList<class_2791> list = new ArrayList<class_2791>();
        for (int k = class_4076.method_18675((int)boundingBox.method_35417()); k <= class_4076.method_18675((int)boundingBox.method_35420()); ++k) {
            for (int l = class_4076.method_18675((int)boundingBox.method_35415()); l <= class_4076.method_18675((int)boundingBox.method_35418()); ++l) {
                class_2791 chunkAccess = level.method_8402(l, k, class_2806.field_12803, false);
                if (chunkAccess == null) {
                    return;
                }
                list.add(chunkAccess);
            }
        }
        class_2960 reference = new class_2960(trajectory.getWarheadData().method_10558("biome"));
        Optional registryOptional = level.method_30349().method_33310(class_7924.field_41236);
        if (registryOptional.isEmpty()) {
            return;
        }
        Optional biomeHolderOptional = ((class_2378)registryOptional.get()).method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)reference));
        if (biomeHolderOptional.isEmpty()) {
            return;
        }
        for (class_2791 chunkAccess : list) {
            chunkAccess.method_38257(BiomeBrushWarhead.makeResolver(chunkAccess, boundingBox, (class_6880<class_1959>)((class_6880)biomeHolderOptional.get()), holder -> true), level.method_14178().method_41248().method_42371());
            chunkAccess.method_12008(true);
        }
        level.method_14178().field_17254.method_49421(list);
        level.method_45447(null, class_2338.method_49638((class_2374)hitPosition), class_3417.field_15152, class_3419.field_15254);
        level.method_45447(null, class_2338.method_49638((class_2374)hitPosition), class_3417.field_14800, class_3419.field_15254);
        for (int i = 0; i < 20; ++i) {
            class_243 pos = new class_243(Math.random() * 16.0 * 2.0, Math.random() * 16.0 * 2.0, Math.random() * 16.0 * 2.0).method_1019(hitPosition).method_1023(16.0, 16.0, 16.0);
            level.method_14199((class_2394)class_2398.field_11220, pos.field_1352, pos.field_1351, pos.field_1350, 3, 0.0, 0.0, 0.0, 2.0);
        }
    }

    private static class_6780 makeResolver(class_2791 chunkAccess, class_3341 boundingBox, class_6880<class_1959> holder, Predicate<class_6880<class_1959>> predicate) {
        return (i, j, k, sampler) -> {
            int l = class_5742.method_33101((int)i);
            int m = class_5742.method_33101((int)j);
            int n = class_5742.method_33101((int)k);
            class_6880 holder2 = chunkAccess.method_16359(i, j, k);
            if (boundingBox.method_47593(l, m, n) && predicate.test(holder2)) {
                return holder;
            }
            return holder2;
        };
    }

    @Override
    public class_2487 saveTo(class_1263 container, class_2487 data) {
        for (int i = 0; i < container.method_5439(); ++i) {
            BiomeVialItem item;
            class_1799 itemStack = container.method_5438(i);
            if (!itemStack.method_31574((class_1792)Items.BIOME_VIAL.get()) || !(item = (BiomeVialItem)itemStack.method_7909()).isFull(itemStack)) continue;
            data.method_10582("biome", itemStack.method_7969().method_10558("biome"));
            return data;
        }
        return super.saveTo(container, data);
    }

    @Override
    public class_2960 getResourceLocation() {
        return new class_2960("createmissiles", "biome_brush_warhead");
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"warheads.createmissiles.biome_brush_warhead");
    }
}

