/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record MissileIngredient(int count, class_1799[] items, class_6862<class_1792>[] tags) {
    public static final MissileIngredient EMPTY = new MissileIngredient(0, new class_1799[0], new class_6862[0]);

    public boolean isEmpty() {
        return this.items.length == 0 && this.tags.length == 0 || this.count == 0;
    }

    public boolean test(@Nullable class_1799 itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return itemStack.method_7960();
        }
        for (class_1799 class_17992 : this.items) {
            if (!class_17992.method_31574(itemStack.method_7909())) continue;
            return true;
        }
        for (class_1799 class_17993 : this.tags) {
            if (!itemStack.method_31573((class_6862)class_17993)) continue;
            return true;
        }
        return false;
    }

    public void toNetwork(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_34062(Arrays.asList(this.items()), class_2540::method_10793);
        friendlyByteBuf.method_34062(Arrays.asList(this.tags()), (a, b) -> a.method_10812(b.comp_327()));
        friendlyByteBuf.writeInt(this.count);
    }

    public List<class_1799> getAllValidItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>(Arrays.stream(this.items()).toList());
        for (class_6862<class_1792> tag : this.tags()) {
            for (class_6880 holder : class_7923.field_41178.method_40286(tag)) {
                items.add(new class_1799(holder));
            }
        }
        return items;
    }

    public static MissileIngredient fromJson(JsonElement rawJson, boolean b) {
        if (rawJson != null && !rawJson.isJsonNull()) {
            if (rawJson.isJsonObject()) {
                JsonObject ingredient = rawJson.getAsJsonObject();
                int count = class_3518.method_15260((JsonObject)ingredient, (String)"count");
                class_1799[] items = new class_1799[]{};
                if (ingredient.has("items")) {
                    JsonArray ingredientArray = class_3518.method_15261((JsonObject)ingredient, (String)"items");
                    items = StreamSupport.stream(ingredientArray.spliterator(), false).map(MissileIngredient::itemStackFromJson).toList().toArray(new class_1799[0]);
                }
                class_6862[] tags = new class_6862[]{};
                if (ingredient.has("tags")) {
                    JsonArray tagArray = class_3518.method_15261((JsonObject)ingredient, (String)"tags");
                    tags = StreamSupport.stream(tagArray.spliterator(), false).map(MissileIngredient::tagFromJson).toList().toArray(new class_6862[0]);
                }
                return new MissileIngredient(count, items, tags);
            }
            throw new JsonSyntaxException("Value of key 'ingredients' must be an object");
        }
        throw new JsonSyntaxException("Value of key 'ingredients' cannot be null");
    }

    public static MissileIngredient fromNetwork(class_2540 friendlyByteBuf) {
        class_1799[] items = friendlyByteBuf.method_34066(class_2540::method_10819).toArray(new class_1799[0]);
        class_6862[] tags = friendlyByteBuf.method_34066(buf -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810())).toArray(new class_6862[0]);
        int count = friendlyByteBuf.readInt();
        return new MissileIngredient(count, items, tags);
    }

    private static class_1799 itemStackFromJson(JsonElement json) {
        class_2960 resourceLocation = new class_2960(json.getAsString());
        return new class_1799((class_1935)class_7923.field_41178.method_10223(resourceLocation));
    }

    private static class_6862<class_1792> tagFromJson(JsonElement json) {
        class_2960 resourceLocation = new class_2960(json.getAsString());
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
    }
}

