/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8566;
import net.woukie.createmissiles.registry.RecipeSerializers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtShapedRecipe
extends class_1869 {
    public NbtShapedRecipe(class_2960 resourceLocation, String string, class_7710 craftingBookCategory, int i, int j, class_2371<class_1856> nonNullList, class_1799 itemStack, boolean bl) {
        super(resourceLocation, string, craftingBookCategory, i, j, nonNullList, itemStack, bl);
    }

    public NbtShapedRecipe(class_2960 resourceLocation, String string, class_7710 craftingBookCategory, int i, int j, class_2371<class_1856> nonNullList, class_1799 itemStack) {
        super(resourceLocation, string, craftingBookCategory, i, j, nonNullList, itemStack);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeSerializers.NBT_CRAFTING_SHAPED.get();
    }

    private List<NbtIngredient> getNbtIngredients() {
        class_2371 ingredients = this.method_8117();
        return ingredients.stream().map(ingredient -> NbtIngredient.fromSuper(ingredient)).toList();
    }

    private boolean matches(class_8566 craftingContainer, int i, int j, boolean bl) {
        for (int k = 0; k < craftingContainer.method_17398(); ++k) {
            for (int l = 0; l < craftingContainer.method_17397(); ++l) {
                int m = k - i;
                int n = l - j;
                NbtIngredient ingredient = NbtIngredient.EMPTY;
                if (m >= 0 && n >= 0 && m < this.method_8150() && n < this.method_8158()) {
                    ingredient = bl ? this.getNbtIngredients().get(this.method_8150() - m - 1 + n * this.method_8150()) : this.getNbtIngredients().get(m + n * this.method_8150());
                }
                if (ingredient.method_8093(craftingContainer.method_5438(k + l * craftingContainer.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean method_17728(class_8566 craftingContainer, class_1937 level) {
        for (int i = 0; i <= craftingContainer.method_17398() - this.method_8150(); ++i) {
            for (int j = 0; j <= craftingContainer.method_17397() - this.method_8158(); ++j) {
                if (this.matches(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    static String[] patternFromJson(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static class_2371<class_1856> dissolvePattern(String[] strings, Map<String, class_1856> map, int i, int j) {
        class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(map.keySet());
        set.remove(" ");
        for (int k = 0; k < strings.length; ++k) {
            for (int l = 0; l < strings[k].length(); ++l) {
                String string = strings[k].substring(l, l + 1);
                class_1856 ingredient = map.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(l + i * k, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonNullList;
    }

    static Map<String, class_1856> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            class_1856 i = NbtIngredient.fromJson((JsonElement)entry.getValue(), false);
            map.put((String)entry.getKey(), i);
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    static String[] shrink(String ... strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < strings.length; ++m) {
            String string = strings[m];
            i = Math.min(i, NbtShapedRecipe.firstNonSpace(string));
            int n = NbtShapedRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] strings2 = new String[strings.length - l - k];
        for (int o = 0; o < strings2.length; ++o) {
            strings2[o] = strings[o + k].substring(i, j + 1);
        }
        return strings2;
    }

    private static int firstNonSpace(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static class NbtIngredient
    extends class_1856 {
        public static final NbtIngredient EMPTY = new NbtIngredient(Stream.empty());

        public static NbtIngredient fromSuper(class_1856 ingredient) {
            return new NbtIngredient(Arrays.stream(ingredient.field_9019));
        }

        public boolean method_8093(@Nullable class_1799 itemStack) {
            if (itemStack == null) {
                return false;
            }
            if (this.method_8103()) {
                return itemStack.method_7960();
            }
            for (class_1799 requiredItem : this.method_8105()) {
                boolean requireTag = requiredItem.method_7985();
                if (!requiredItem.method_31574(itemStack.method_7909()) || requireTag && !requiredItem.method_7969().equals((Object)itemStack.method_7969())) continue;
                return true;
            }
            return false;
        }

        public NbtIngredient(Stream<? extends class_1856.class_1859> stream) {
            super(stream);
        }

        public static class_1856.class_1859 valueFromJson(JsonObject jsonObject) {
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
            }
            if (jsonObject.has("item")) {
                return new class_1856.class_1857(NbtShapedRecipe.method_35228((JsonObject)jsonObject));
            }
            if (jsonObject.has("tag")) {
                class_2960 resourceLocation = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"tag"));
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
                return new TagValue((class_6862<class_1792>)tagKey);
            }
            throw new JsonParseException("An ingredient entry needs either a tag or an item");
        }

        public static class_1856 fromJson(@Nullable JsonElement jsonElement, boolean bl) {
            if (jsonElement != null && !jsonElement.isJsonNull()) {
                if (jsonElement.isJsonObject()) {
                    return NbtIngredient.method_8092(Stream.of(NbtIngredient.valueFromJson(jsonElement.getAsJsonObject())));
                }
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    if (jsonArray.size() == 0 && !bl) {
                        throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                    }
                    return NbtIngredient.method_8092(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElementx -> NbtIngredient.valueFromJson(class_3518.method_15295((JsonElement)jsonElementx, (String)"item"))));
                }
                throw new JsonSyntaxException("Expected item to be object or array of objects");
            }
            throw new JsonSyntaxException("Item cannot be null");
        }

        public static class TagValue
        implements class_1856.class_1859 {
            private final class_6862<class_1792> tag;

            TagValue(class_6862<class_1792> tagKey) {
                this.tag = tagKey;
            }

            public Collection<class_1799> method_8108() {
                ArrayList list = Lists.newArrayList();
                for (class_6880 holder : class_7923.field_41178.method_40286(this.tag)) {
                    list.add(new class_1799(holder));
                }
                return list;
            }

            public JsonObject method_8109() {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("tag", this.tag.comp_327().toString());
                return jsonObject;
            }
        }
    }

    public static class Serializer
    implements class_1865<NbtShapedRecipe> {
        public NbtShapedRecipe fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
            String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_7710 craftingBookCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)jsonObject, (String)"category", null), (Enum)class_7710.field_40251);
            Map<String, class_1856> keys = NbtShapedRecipe.keyFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] strings = NbtShapedRecipe.shrink(NbtShapedRecipe.patternFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
            int width = strings[0].length();
            int height = strings.length;
            class_2371<class_1856> ingredients = NbtShapedRecipe.dissolvePattern(strings, keys, width, height);
            class_1799 result = NbtShapedRecipe.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            boolean notify = class_3518.method_15258((JsonObject)jsonObject, (String)"show_notification", (boolean)true);
            return new NbtShapedRecipe(resourceLocation, group, craftingBookCategory, width, height, ingredients, result, notify);
        }

        public NbtShapedRecipe fromNetwork(class_2960 resourceLocation, class_2540 friendlyByteBuf) {
            int i = friendlyByteBuf.method_10816();
            int j = friendlyByteBuf.method_10816();
            String string = friendlyByteBuf.method_19772();
            class_7710 craftingBookCategory = (class_7710)friendlyByteBuf.method_10818(class_7710.class);
            class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            nonNullList.replaceAll(ignored -> class_1856.method_8086((class_2540)friendlyByteBuf));
            class_1799 itemStack = friendlyByteBuf.method_10819();
            boolean bl = friendlyByteBuf.readBoolean();
            return new NbtShapedRecipe(resourceLocation, string, craftingBookCategory, i, j, (class_2371<class_1856>)nonNullList, itemStack, bl);
        }

        public void toNetwork(class_2540 friendlyByteBuf, NbtShapedRecipe recipe) {
            friendlyByteBuf.method_10804(recipe.method_8150());
            friendlyByteBuf.method_10804(recipe.method_8158());
            friendlyByteBuf.method_10814(recipe.method_8112());
            friendlyByteBuf.method_10817((Enum)recipe.method_45441());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(friendlyByteBuf);
            }
            friendlyByteBuf.method_10793(recipe.method_8110(null));
            friendlyByteBuf.writeBoolean(recipe.method_49188());
        }
    }
}

