/*
 * Decompiled with CFR 0.152.
 */
package me.electrobrine.quill_notifications;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.UUID;
import me.electrobrine.quill_notifications.QuillNotifications;
import me.mrnavastar.sqlib.api.DataContainer;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.text.Component;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class Notification {
    private int databaseID = -1;
    private final UUID uuid;
    private class_3222 player;
    private class_5250 message;
    @NotNull
    private Component component;
    private JsonElement metadata;
    private class_3414 sound;
    private ArrayList<String> commands;
    private Long commandDelay;
    private Long expiry;
    private Long creationTime;

    public void setMessage(class_5250 newMessage) {
        this.message = newMessage;
        this.component = MinecraftServerAudiences.of((MinecraftServer)QuillNotifications.server).nonWrappingSerializer().deserialize((Object)newMessage);
    }

    public void setComponent(Component newComponent) {
        this.component = newComponent;
        this.message = (class_5250)MinecraftServerAudiences.of((MinecraftServer)QuillNotifications.server).nonWrappingSerializer();
    }

    public class_3222 getPlayerEntity() {
        if (this.player == null) {
            this.player = QuillNotifications.playerManager.get(this.getUuid());
        }
        return this.player;
    }

    public void cancel() {
        if (this.databaseID == -1) {
            return;
        }
        QuillNotifications.mailbox.getContainer(this.databaseID).ifPresent(DataContainer::delete);
    }

    public Notification(int databaseID, UUID uuid, class_3222 player, class_5250 message, @NotNull Component component, JsonElement metadata, class_3414 sound, ArrayList<String> commands, Long commandDelay, Long expiry, Long creationTime) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.databaseID = databaseID;
        this.uuid = uuid;
        this.player = player;
        this.message = message;
        this.component = component;
        this.metadata = metadata;
        this.sound = sound;
        this.commands = commands;
        this.commandDelay = commandDelay;
        this.expiry = expiry;
        this.creationTime = creationTime;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public class_5250 getMessage() {
        return this.message;
    }

    @NotNull
    public Component getComponent() {
        return this.component;
    }

    public void setMetadata(JsonElement metadata) {
        this.metadata = metadata;
    }

    public JsonElement getMetadata() {
        return this.metadata;
    }

    public void setSound(class_3414 sound) {
        this.sound = sound;
    }

    public class_3414 getSound() {
        return this.sound;
    }

    public void setCommands(ArrayList<String> commands) {
        this.commands = commands;
    }

    public ArrayList<String> getCommands() {
        return this.commands;
    }

    public void setCommandDelay(Long commandDelay) {
        this.commandDelay = commandDelay;
    }

    public Long getCommandDelay() {
        return this.commandDelay;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }
}

