/*
 * Decompiled with CFR 0.152.
 */
package me.electrobrine.quill_notifications;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.electrobrine.quill_notifications.Notification;
import me.electrobrine.quill_notifications.NotifyCommand;
import me.electrobrine.quill_notifications.api.NotificationBuilder;
import me.mrnavastar.sqlib.SQLib;
import me.mrnavastar.sqlib.api.DataContainer;
import me.mrnavastar.sqlib.api.DataStore;
import me.mrnavastar.sqlib.api.types.GsonTypes;
import me.mrnavastar.sqlib.api.types.JavaTypes;
import me.mrnavastar.sqlib.api.types.MinecraftTypes;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class QuillNotifications
implements ModInitializer {
    public static DataStore mailbox = SQLib.getDatabase().dataStore("Quill", "Messages");
    public static HashMap<UUID, class_3222> playerManager = new HashMap();
    public static MinecraftServer server;

    public void onInitialize() {
        QuillNotifications.log("dipping the ink quill", Level.INFO);
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> NotifyCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            UUID playerUUID = player.method_5667();
            playerManager.put(playerUUID, player);
            NotificationBuilder notification = new NotificationBuilder(playerUUID);
            mailbox.getContainers("receiver", (Object)playerUUID).forEach(message -> {
                notification.setMessage((class_5250)message.get(MinecraftTypes.TEXT, "text").orElseGet(() -> null));
                notification.setSound(message.get(MinecraftTypes.SOUND, "sound").orElseGet(() -> null));
                notification.setMetadata(message.get(GsonTypes.ELEMENT, "metadata").orElseGet(() -> null));
                ArrayList<String> stringCommands = new ArrayList<String>();
                for (JsonElement command : (JsonArray)Objects.requireNonNull(message.get(GsonTypes.ELEMENT, "commands").orElseGet(() -> null))) {
                    stringCommands.add(command.getAsString());
                }
                notification.setCommands((String[])stringCommands.toArray(String[]::new));
                notification.setCommandDelay(message.get(JavaTypes.LONG, "commandDelay").orElseGet(() -> 0L));
                notification.setExpiry(message.get(JavaTypes.LONG, "expiry").orElseGet(() -> 0L));
                notification.send();
                mailbox.getContainer(message.getId()).ifPresent(DataContainer::delete);
            });
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            UUID playerUUID = handler.method_32311().method_5667();
            playerManager.remove(playerUUID);
        });
    }

    private static void log(String message, Level level) {
        LogManager.getLogger().log(level, "[Quill Notifications] " + message);
    }

    public static ArrayList<Notification> getNotifications(UUID uuid) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        mailbox.getContainers("receiver", (Object)uuid).forEach(container -> {
            ArrayList<String> stringCommands = new ArrayList<String>();
            for (JsonElement command : (JsonArray)Objects.requireNonNull(container.get(GsonTypes.ELEMENT, "commands").orElseGet(() -> null))) {
                stringCommands.add(command.getAsString());
            }
            Notification notification = new Notification(container.getId(), uuid, null, (class_5250)container.get(MinecraftTypes.TEXT, "text").orElseGet(() -> null), MinecraftServerAudiences.of((MinecraftServer)server).nonWrappingSerializer().deserialize((Object)Objects.requireNonNull(container.get(MinecraftTypes.TEXT, "text").orElseGet(() -> null))), container.get(GsonTypes.ELEMENT, "metadata").orElseGet(() -> null), container.get(MinecraftTypes.SOUND, "sound").orElseGet(() -> null), stringCommands, container.get(JavaTypes.LONG, "commandDelay").orElseGet(() -> null), container.get(JavaTypes.LONG, "expiry").orElseGet(() -> null), container.get(JavaTypes.LONG, "creationTime").orElseGet(() -> null));
            notifications.add(notification);
        });
        return notifications;
    }
}

