/*
 * Decompiled with CFR 0.152.
 */
package me.electrobrine.quill_notifications.api;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.electrobrine.quill_notifications.Notification;
import me.electrobrine.quill_notifications.QuillNotifications;
import me.electrobrine.quill_notifications.Style;
import me.electrobrine.quill_notifications.api.Pigeon;
import me.electrobrine.quill_notifications.api.Scribe;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.text.Component;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class NotificationBuilder {
    private final UUID uuid;
    private class_5250 message = null;
    private String stringMessage = null;
    private Scribe style = Scribe.NONE;
    private Component componentMessage = null;
    private JsonElement metadata = null;
    private class_3414 sound = null;
    private final ArrayList<String> commands = new ArrayList();
    private long commandDelay = 0L;
    private long expiry = 0L;
    private final Long creationTime = new Date().getTime();

    public static NotificationBuilder Notification(UUID uuid) {
        return new NotificationBuilder(uuid);
    }

    public NotificationBuilder setMessage(class_5250 message) {
        this.stringMessage = null;
        this.componentMessage = null;
        this.message = message;
        return this;
    }

    public NotificationBuilder setMessage(String message) {
        this.message = null;
        this.componentMessage = null;
        this.stringMessage = message;
        return this;
    }

    public NotificationBuilder setMessage(Component message) {
        this.message = null;
        this.stringMessage = null;
        this.componentMessage = message;
        return this;
    }

    public NotificationBuilder setStyle(Scribe style) {
        this.style = style;
        return this;
    }

    public NotificationBuilder setMetadata(JsonElement metadata) {
        this.metadata = metadata;
        return this;
    }

    public NotificationBuilder setSound(class_3414 sound) {
        this.sound = sound;
        return this;
    }

    public NotificationBuilder setCommands(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
        return this;
    }

    public NotificationBuilder setCommandDelay(int amount, TimeUnit unit) {
        this.commandDelay = unit.toMillis(amount);
        return this;
    }

    public NotificationBuilder setCommandDelay(long timeMillis) {
        this.commandDelay = timeMillis;
        return this;
    }

    public NotificationBuilder setExpiry(int amount, TimeUnit unit) {
        this.expiry = unit.toMillis(amount);
        return this;
    }

    public NotificationBuilder setExpiry(long timeMillis) {
        this.expiry = timeMillis;
        return this;
    }

    public Notification build() {
        if (this.stringMessage != null) {
            this.message = Style.stylize(this.stringMessage, this.style);
        } else if (this.componentMessage != null) {
            this.message = (class_5250)MinecraftServerAudiences.of((MinecraftServer)QuillNotifications.server).nonWrappingSerializer().serialize(this.componentMessage);
        }
        return new Notification(-1, this.uuid, null, this.message, MinecraftServerAudiences.of((MinecraftServer)QuillNotifications.server).nonWrappingSerializer().deserialize((Object)this.message), this.metadata, this.sound, this.commands, this.commandDelay, this.expiry, this.creationTime);
    }

    public void send() {
        Pigeon.send(this.build());
    }

    public NotificationBuilder(UUID uuid) {
        this.uuid = uuid;
    }
}

