/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.fcgymbadges.item;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import kiwiapollo.fcgymbadges.item.LockedGymBadge;
import kiwiapollo.fcgymbadges.item.LockedGymBadgeItem;
import kiwiapollo.fcgymbadges.predicate.LuckPermsPredicate;
import kiwiapollo.fcgymbadges.predicate.PermissionLevelPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class GymBadgeUnlocker
extends class_1792 {
    public GymBadgeUnlocker() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.method_8608()) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        if (!this.hasLockedGymBadgeInOtherHand(user, hand)) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_1799 locked = user.method_5998(this.getOtherHand(hand));
        class_1799 unlocker = user.method_5998(hand);
        if (!this.hasPermission(user, (LockedGymBadge)locked.method_7909())) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_1792 badge = ((LockedGymBadge)locked.method_7909()).getGymBadge();
        user.method_7270(badge.method_7854());
        if (!user.method_7337()) {
            locked.method_7934(1);
            unlocker.method_7934(1);
        }
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    private boolean hasPermission(class_1657 user, LockedGymBadge locked) {
        return new PermissionPredicate(locked).test(user);
    }

    private boolean hasLockedGymBadgeInOtherHand(class_1657 user, class_1268 hand) {
        class_1792 item = user.method_5998(this.getOtherHand(hand)).method_7909();
        return Arrays.stream(LockedGymBadgeItem.values()).map(LockedGymBadgeItem::getItem).anyMatch(item::equals);
    }

    private class_1268 getOtherHand(class_1268 hand) {
        return switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case class_1268.field_5808 -> class_1268.field_5810;
            case class_1268.field_5810 -> class_1268.field_5808;
        };
    }

    private static class PermissionPredicate
    implements Predicate<class_1657> {
        private static final int OP_LEVEL = 2;
        private final LuckPermsPredicate luckperms;
        private final PermissionLevelPredicate level;

        public PermissionPredicate(LockedGymBadge locked) {
            this.luckperms = new LuckPermsPredicate(this.getPermissionNodes(locked));
            this.level = new PermissionLevelPredicate(2);
        }

        private List<String> getPermissionNodes(LockedGymBadge locked) {
            return List.of(String.format("%s.%s.%s", "fcgymbadges", locked.getPermissionNode(), "unlock"));
        }

        @Override
        public boolean test(class_1657 player) {
            return this.luckperms.test(player) || this.level.test(player);
        }
    }
}

