/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.puppet;

import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import me.senseiwells.puppet.PuppetPlayer;
import me.senseiwells.puppet.PuppetPlayerConfig;
import me.senseiwells.puppet.PuppetPlayers;
import me.senseiwells.puppet.command.PuppetPlayerCommand;
import me.senseiwells.puppet.mixins.CachedUserNameToIdResolverAccessor;
import me.senseiwells.puppet.mixins.ServicesAccessor;
import me.senseiwells.puppet.network.MineToolsGameProfileRepository;
import me.senseiwells.puppet.utils.PuppetPlayerRegistries;
import net.casual.arcade.commands.CommandTree;
import net.casual.arcade.commands.CommandUtilsKt;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.server.ServerRegisterCommandEvent;
import net.casual.arcade.events.server.ServerSaveEvent;
import net.casual.arcade.events.server.ServerStartEvent;
import net.casual.arcade.events.server.ServerStopEvent;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.npc.FakePlayer;
import net.casual.arcade.npc.configuration.FakePlayerConstructor;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_11561;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.class_7497;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/senseiwells/puppet/PuppetPlayers;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lnet/minecraft/server/MinecraftServer;", "server", "loadFakePlayers", "(Lnet/minecraft/server/MinecraftServer;)V", "saveFakePlayers", "Ljava/nio/file/Path;", "getFakePlayerDat", "(Lnet/minecraft/server/MinecraftServer;)Ljava/nio/file/Path;", "", "MOD_ID", "Ljava/lang/String;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "Lme/senseiwells/puppet/PuppetPlayerConfig;", "config", "Lme/senseiwells/puppet/PuppetPlayerConfig;", "getConfig", "()Lme/senseiwells/puppet/PuppetPlayerConfig;", "PuppetPlayers"})
@SourceDebugExtension(value={"SMAP\nPuppetPlayers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PuppetPlayers.kt\nme/senseiwells/puppet/PuppetPlayers\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n*L\n1#1,107:1\n104#2,2:108\n104#2,2:110\n104#2,2:112\n104#2,2:114\n*S KotlinDebug\n*F\n+ 1 PuppetPlayers.kt\nme/senseiwells/puppet/PuppetPlayers\n*L\n38#1:108,2\n41#1:110,2\n51#1:112,2\n56#1:114,2\n*E\n"})
public final class PuppetPlayers
implements ModInitializer {
    @NotNull
    public static final PuppetPlayers INSTANCE = new PuppetPlayers();
    @NotNull
    public static final String MOD_ID = "puppet-players";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final PuppetPlayerConfig config;

    private PuppetPlayers() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final PuppetPlayerConfig getConfig() {
        return config;
    }

    public void onInitialize() {
        ListenerRegistry $this$register$iv;
        PuppetPlayerRegistries.INSTANCE.load();
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ServerRegisterCommandEvent> listener$iv = PuppetPlayers::onInitialize$lambda$0;
        boolean $i$f$register = false;
        $this$register$iv.register(ServerRegisterCommandEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = PuppetPlayers::onInitialize$lambda$1;
        $i$f$register = false;
        $this$register$iv.register(ServerStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = PuppetPlayers::onInitialize$lambda$2;
        $i$f$register = false;
        $this$register$iv.register(ServerSaveEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = PuppetPlayers::onInitialize$lambda$3;
        $i$f$register = false;
        $this$register$iv.register(ServerStopEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
    }

    private final void loadFakePlayers(MinecraftServer server) {
        Path path;
        block10: {
            block9: {
                path = this.getFakePlayerDat(server);
                if (!config.getReloadPuppetPlayers()) break block9;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
            }
            return;
        }
        try {
            class_2487 class_24872 = class_2507.method_10633((Path)path);
            if (class_24872 == null) {
                return;
            }
            class_2487 wrapper = class_24872;
            Optional optional = wrapper.method_67491("players", class_4844.field_41525.listOf());
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"read(...)");
            List players = (List)OptionalsKt.getOrNull((Optional)optional);
            if (players != null) {
                for (UUID player : players) {
                    Intrinsics.checkNotNull((Object)player);
                    FakePlayer.Companion.join(server, player, (FakePlayerConstructor)loadFakePlayers.1.INSTANCE);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to load puppet players", (Throwable)e);
        }
    }

    private final void saveFakePlayers(MinecraftServer server) {
        ArrayList<UUID> players = new ArrayList<UUID>();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!(player instanceof PuppetPlayer)) continue;
            players.add(((PuppetPlayer)player).method_5667());
        }
        class_2487 wrapper = new class_2487();
        wrapper.method_67494("players", class_4844.field_41525.listOf(), players);
        try {
            class_2507.method_10630((class_2487)wrapper, (Path)this.getFakePlayerDat(server));
        }
        catch (Exception e) {
            logger.error("Failed to save puppet players", (Throwable)e);
        }
    }

    private final Path getFakePlayerDat(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve("puppet-players.dat");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final void onInitialize$lambda$0(ServerRegisterCommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandTree[] commandTreeArray = new CommandTree[]{PuppetPlayerCommand.INSTANCE};
        CommandUtilsKt.register((ServerRegisterCommandEvent)event, (CommandTree[])commandTreeArray);
    }

    private static final void onInitialize$lambda$1(ServerStartEvent serverStartEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartEvent, (String)"<destruct>");
        MinecraftServer server = serverStartEvent.component1();
        INSTANCE.loadFakePlayers(server);
        if (config.getUseMineToolsApi()) {
            Proxy proxy = Proxy.NO_PROXY;
            Intrinsics.checkNotNullExpressionValue((Object)proxy, (String)"NO_PROXY");
            MineToolsGameProfileRepository repository = new MineToolsGameProfileRepository(proxy);
            class_7497 services = server.method_73550();
            Intrinsics.checkNotNull((Object)services, (String)"null cannot be cast to non-null type me.senseiwells.puppet.mixins.ServicesAccessor");
            ((ServicesAccessor)services).setProfileRepository(repository);
            class_11561 class_115612 = services.comp_4407();
            Intrinsics.checkNotNull((Object)class_115612, (String)"null cannot be cast to non-null type me.senseiwells.puppet.mixins.CachedUserNameToIdResolverAccessor");
            ((CachedUserNameToIdResolverAccessor)class_115612).setProfileRepository(repository);
        }
    }

    private static final void onInitialize$lambda$2(ServerSaveEvent serverSaveEvent) {
        Intrinsics.checkNotNullParameter((Object)serverSaveEvent, (String)"<destruct>");
        MinecraftServer server = serverSaveEvent.component1();
        boolean stopping = serverSaveEvent.component2();
        if (!stopping) {
            INSTANCE.saveFakePlayers(server);
        }
    }

    private static final void onInitialize$lambda$3(ServerStopEvent serverStopEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStopEvent, (String)"<destruct>");
        MinecraftServer server = serverStopEvent.component1();
        INSTANCE.saveFakePlayers(server);
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        for (class_3222 player : CollectionsKt.toList((Iterable)list)) {
            if (!(player instanceof PuppetPlayer)) continue;
            ((PuppetPlayer)player).field_13987.method_52396((class_2561)class_2561.method_43473());
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        PuppetPlayers.logger = logger;
        config = PuppetPlayerConfig.Companion.read();
    }
}

