/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.puppet.network;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\f\u001a\u00020\u000b2\u0010\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lme/senseiwells/puppet/network/MineToolsGameProfileRepository;", "Lcom/mojang/authlib/GameProfileRepository;", "Ljava/net/Proxy;", "proxy", "<init>", "(Ljava/net/Proxy;)V", "", "", "names", "Lcom/mojang/authlib/ProfileLookupCallback;", "callback", "", "findProfilesByNames", "([Ljava/lang/String;Lcom/mojang/authlib/ProfileLookupCallback;)V", "name", "Ljava/util/Optional;", "Lcom/mojang/authlib/yggdrasil/response/NameAndId;", "findProfileByName", "(Ljava/lang/String;)Ljava/util/Optional;", "Lcom/mojang/authlib/minecraft/client/MinecraftClient;", "kotlin.jvm.PlatformType", "client", "Lcom/mojang/authlib/minecraft/client/MinecraftClient;", "", "nextQueryTime", "J", "Companion", "PuppetPlayers"})
@SourceDebugExtension(value={"SMAP\nMineToolsGameProfileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MineToolsGameProfileRepository.kt\nme/senseiwells/puppet/network/MineToolsGameProfileRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n774#2:53\n865#2,2:54\n*S KotlinDebug\n*F\n+ 1 MineToolsGameProfileRepository.kt\nme/senseiwells/puppet/network/MineToolsGameProfileRepository\n*L\n19#1:53\n19#1:54,2\n*E\n"})
public final class MineToolsGameProfileRepository
implements GameProfileRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final MinecraftClient client;
    private long nextQueryTime;
    private static final int QUERY_COOLDOWN = 200;

    public MineToolsGameProfileRepository(@NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.client = MinecraftClient.unauthenticated((Proxy)proxy);
    }

    /*
     * WARNING - void declaration
     */
    public void findProfilesByNames(@NotNull String[] names, @NotNull ProfileLookupCallback callback) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Iterable $this$filter$iv = ArraysKt.filterNotNull((Object[])names);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set criteria = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        for (String name : criteria) {
            long cooldown = this.nextQueryTime - System.currentTimeMillis();
            if (cooldown > 0L) {
                Thread.sleep(cooldown);
            }
            this.nextQueryTime = System.currentTimeMillis() + (long)200;
            URL url = new URI("https://api.minetools.eu/uuid/" + name).toURL();
            try {
                NameAndId profile;
                if ((NameAndId)this.client.get(url, NameAndId.class) == null) {
                    throw new ProfileNotFoundException("Server did not find the request profile");
                }
                callback.onProfileLookupSucceeded(profile.name(), profile.id());
            }
            catch (Exception e) {
                callback.onProfileLookupFailed(name, e);
            }
        }
    }

    @NotNull
    public Optional<NameAndId> findProfileByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URL url = new URI("https://api.minetools.eu/uuid/" + name).toURL();
        try {
            Optional<Object> optional = Optional.ofNullable(this.client.get(url, NameAndId.class));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }
        catch (MinecraftClientException minecraftClientException) {
            Optional<NameAndId> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/senseiwells/puppet/network/MineToolsGameProfileRepository$Companion;", "", "<init>", "()V", "", "QUERY_COOLDOWN", "I", "PuppetPlayers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

