/*
 * Decompiled with CFR 0.152.
 */
package net.tunly;

import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.tunly.ModConfig;

public class Clock
implements HudRenderCallback {
    public void onHudRender(class_332 drawContext, class_9779 renderTickCounter) {
        if (!ModConfig.get().enableText && !ModConfig.get().showInActionBar) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null) {
            class_327 renderer = class_310.method_1551().field_1772;
            long timeOfDay = player.method_37908().method_8532();
            String timeString = ModConfig.get().twelveHourFormat ? Clock.formatTime12Hour(timeOfDay) : Clock.formatTime24Hour(timeOfDay);
            class_5250 text = class_2561.method_43470((String)timeString);
            if (player.method_37908().method_8510() % 20L == 0L && ModConfig.get().showInActionBar) {
                class_310.method_1551().field_1705.method_1758((class_2561)text, false);
            }
            if (ModConfig.get().enableText) {
                int textWidth = client.field_1772.method_27525((class_5348)text);
                Objects.requireNonNull(client.field_1772);
                int textHeight = 9;
                int screenWidth = client.method_22683().method_4486();
                int screenHeight = client.method_22683().method_4502();
                int x = (int)((float)screenWidth * ModConfig.get().getNormalizedX()) - textWidth / 2;
                int y = (int)((float)screenHeight * ModConfig.get().getNormalizedY());
                x = Math.max(0, Math.min(x, screenWidth - textWidth));
                y = Math.max(0, Math.min(y, screenHeight - 9));
                int color = 0xFFFFFF;
                drawContext.method_51439(renderer, class_2561.method_30163((String)timeString), x, y, color, false);
            }
        }
    }

    public static int ticksToMinutes(long timeOfDay) {
        return (int)((double)(timeOfDay %= 24000L) / 1000.0 * 60.0);
    }

    public static String formatTime24Hour(long timeOfDay) {
        String indicator = "";
        indicator = (timeOfDay %= 24000L) >= 0L && timeOfDay < 12500L ? "\u00a76\u2600\u00a7r" : "\u00a79\u263d\u00a7r";
        int hours = (int)(timeOfDay / 1000L);
        int minutes = (int)((double)(timeOfDay % 1000L) / 16.666);
        hours = (hours + 6) % 24;
        String formattedTime = String.format("%02d:%02d", hours, minutes);
        String output = String.format("%s %s", indicator, formattedTime);
        return output;
    }

    public static String formatTime12Hour(long timeOfDay) {
        String indicator = "";
        indicator = (timeOfDay %= 24000L) >= 0L && timeOfDay < 12500L ? "\u00a76\u2600\u00a7r" : "\u00a79\u263d\u00a7r";
        int totalMinutes = (int)((double)timeOfDay / 1000.0 * 60.0) - 360;
        if (totalMinutes < 0) {
            totalMinutes += 1440;
        }
        int hours = totalMinutes / 60 % 24;
        int minutes = totalMinutes % 60;
        int hour12 = hours % 12 == 0 ? 12 : hours % 12;
        String ampm = hours < 12 ? "PM" : "AM";
        String formattedTime = String.format("%02d:%02d %s", hour12, minutes, ampm);
        String output = String.format("%s %s", indicator, formattedTime);
        return output;
    }
}

