/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch;

import com.mrbysco.flowerpatch.Constants;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.platform.Services;
import com.mrbysco.flowerpatch.registration.CompatRegistry;
import com.mrbysco.flowerpatch.registration.PatchRegistry;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CommonClass {
    public static void init() {
        PatchRegistry.loadClass();
        if (CommonClass.modLoaded("biomeswevegone")) {
            CompatRegistry.BiomesWeveGoneCompat.loadClass();
        }
        if (CommonClass.modLoaded("eternal_starlight")) {
            CompatRegistry.EternalStarlightCompat.loadClass();
        }
        if (CommonClass.modLoaded("regions_unexplored")) {
            CompatRegistry.RegionsUnexploredCompat.loadClass();
        }
    }

    private static boolean modLoaded(String modid) {
        return Services.PLATFORM.isModLoaded(modid);
    }

    public static InteractionResult onBlockInteraction(Level level, BlockPos pos, Player player, InteractionHand hand) {
        PatchBlock patchBlock;
        Block block;
        BlockState state = level.getBlockState(pos);
        ItemStack stack = player.getItemInHand(hand);
        if (state.getBlock().asItem().equals(stack.getItem()) || (block = state.getBlock()) instanceof PatchBlock && (patchBlock = (PatchBlock)block).getPatchDelegate().get().asItem().equals(stack.getItem())) {
            Optional<Block> optionalPatch = PatchRegistry.BLOCKS.getEntries().stream().filter(object -> {
                PatchBlock patchBlock;
                Object patt0$temp = object.get();
                return patt0$temp instanceof PatchBlock && (patchBlock = (PatchBlock)patt0$temp).getPatchDelegate().get().asItem().equals(stack.getItem());
            }).map(RegistryObject::get).findFirst();
            if (optionalPatch.isEmpty()) {
                optionalPatch = CompatRegistry.BLOCKS.getEntries().stream().filter(object -> {
                    PatchBlock patchBlock;
                    Object patt0$temp = object.get();
                    return patt0$temp instanceof PatchBlock && (patchBlock = (PatchBlock)patt0$temp).getPatchDelegate().get().asItem().equals(stack.getItem());
                }).map(RegistryObject::get).findFirst();
            }
            if (optionalPatch.isPresent()) {
                Block block2 = optionalPatch.get();
                PatchBlock patchBlock2 = (PatchBlock)block2;
                BlockState newState = block2.defaultBlockState();
                IntegerProperty property = patchBlock2.getProperty();
                if (state.hasProperty((Property)property)) {
                    if (((Integer)state.getValue((Property)property)).intValue() == patchBlock2.getMaxAmount()) {
                        return InteractionResult.FAIL;
                    }
                    newState = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(Math.min(patchBlock2.getMaxAmount(), (Integer)state.getValue((Property)property) + 1)));
                }
                level.setBlockAndUpdate(pos, newState);
                level.playSound((Entity)((Player)null), pos, newState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onBonemeal(Level level, BlockPos pos, BlockState state, ItemStack stack, Player player) {
        Optional<FlowerPatchBlock> flowerPatchOptional;
        if (Services.PLATFORM.flowerToPatchBonemealing() && state.is(Constants.BONEMEAL_ABLE_FLOWERS) && stack.is(Constants.BONEMEAL) && (flowerPatchOptional = PatchRegistry.BLOCKS.getEntries().stream().filter(object -> {
            FlowerPatchBlock flowerPatchBlock;
            Object patt0$temp = object.get();
            return patt0$temp instanceof FlowerPatchBlock && state.is((flowerPatchBlock = (FlowerPatchBlock)patt0$temp).getPatchDelegate().get());
        }).map(object -> (FlowerPatchBlock)object.get()).findFirst()).isPresent()) {
            FlowerPatchBlock patchBlock = flowerPatchOptional.get();
            BlockState newState = patchBlock.defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            level.playSound((Entity)((Player)null), pos, newState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

