/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch;

import com.mrbysco.flowerpatch.CommonClass;
import com.mrbysco.flowerpatch.client.ClientHandler;
import com.mrbysco.flowerpatch.config.PatchConfigNeoForge;
import net.minecraft.core.BlockPos;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="flowerpatch")
public class FlowerPatchNeoForge {
    public FlowerPatchNeoForge(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PatchConfigNeoForge.commonSpec);
        CommonClass.init();
        NeoForge.EVENT_BUS.addListener(this::onBlockInteraction);
        NeoForge.EVENT_BUS.addListener(this::onBonemeal);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::onClientSetup);
        }
    }

    private void onBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        BlockPos pos;
        Level level = event.getLevel();
        InteractionResult result = CommonClass.onBlockInteraction(level, pos = event.getPos(), player = event.getEntity(), event.getHand());
        if (result == InteractionResult.FAIL) {
            event.setUseBlock(TriState.DEFAULT);
        }
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    private void onBonemeal(BonemealEvent event) {
        Player player;
        ItemStack stack;
        BlockState state;
        BlockPos pos;
        Level level = event.getLevel();
        InteractionResult result = CommonClass.onBonemeal(level, pos = event.getPos(), state = event.getState(), stack = event.getStack(), player = event.getPlayer());
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }
}

