/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.datagen;

import com.mrbysco.flowerpatch.Constants;
import com.mrbysco.flowerpatch.block.CompatPatchBlock;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.registration.CompatRegistry;
import com.mrbysco.flowerpatch.registration.PatchRegistry;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ItemTagsProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class PatchDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new Loots(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new PatchBlockTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new PatchItemTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new Language(packOutput));
        generator.addProvider(true, (DataProvider)new Models(packOutput));
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(PatchBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class PatchBlockLoot
        extends BlockLootSubProvider {
            protected PatchBlockLoot(HolderLookup.Provider lookupProvider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
            }

            protected void generate() {
                PatchBlock patch;
                Block block;
                for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                    block = registryObject.get();
                    if (!(block instanceof PatchBlock)) continue;
                    patch = (PatchBlock)block;
                    this.addPatch(patch);
                }
                for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                    block = registryObject.get();
                    if (!(block instanceof PatchBlock)) continue;
                    patch = (PatchBlock)block;
                    this.add(registryObject.get(), LootTable.lootTable());
                }
            }

            private void addPatch(PatchBlock patch) {
                this.add((Block)patch, block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)((ItemLike)patch.getPatchDelegate().get())).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), value -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)value.floatValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)patch.getProperty(), value.intValue()))))))));
            }

            protected Iterable<Block> getKnownBlocks() {
                ArrayList blocks = new ArrayList();
                PatchRegistry.BLOCKS.getEntries().forEach(object -> blocks.add((Block)object.get()));
                CompatRegistry.BLOCKS.getEntries().forEach(object -> blocks.add((Block)object.get()));
                return blocks::iterator;
            }
        }
    }

    public static class PatchBlockTags
    extends BlockTagsProvider {
        public PatchBlockTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider, "flowerpatch");
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Block block = registryObject.get();
                if (!(block instanceof FlowerPatchBlock)) continue;
                FlowerPatchBlock flowerPatchBlock = (FlowerPatchBlock)block;
                this.tag(BlockTags.FLOWERS).add((Object)flowerPatchBlock);
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof CompatPatchBlock)) continue;
                this.tag(BlockTags.FLOWERS).addOptional((Object)registryObject.get());
            }
            this.tag(Constants.BONEMEAL_ABLE_FLOWERS).add((Object[])new Block[]{Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY});
        }
    }

    public static class PatchItemTags
    extends ItemTagsProvider {
        public PatchItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider, "flowerpatch");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Constants.BONEMEAL).add((Object)Items.BONE_MEAL);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "flowerpatch", "en_us");
        }

        protected void addTranslations() {
            PatchBlock patchBlock;
            Block block;
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                block = registryObject.get();
                if (!(block instanceof PatchBlock)) continue;
                patchBlock = (PatchBlock)block;
                this.addBlock(registryObject, I18n.get((String)patchBlock.getPatchDelegate().get().getDescriptionId(), (Object[])new Object[0]) + " Patch");
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                block = registryObject.get();
                if (!(block instanceof PatchBlock)) continue;
                patchBlock = (PatchBlock)block;
                this.addBlock(registryObject, "%s Patch");
            }
            this.add("text.autoconfig.flowerpatch.title", "Flower Patch");
            this.addConfig("general", null, "General", "General Settings");
            this.addConfig("flowerToPatchBonemealing", "general", "Flower to Patch Bonemealing", "Allows flowers to be bonemealed into flower patches");
            this.addConfig("patchBonemealing", "general", "Patch Bonemealing", "Allows flower patches to be bonemealed to add more flowers");
            this.addConfig("placeOnLeaves", "general", "Place on Leaves", "Allows flowers and other bush-like blocks to be place-able on leaves");
        }

        private void addConfig(String path, @Nullable String category, String name, @Nullable String description) {
            Object categoryString = category == null ? "" : category + ".";
            this.add("flowerpatch.configuration." + path, name);
            this.add("text.autoconfig.flowerpatch.option." + (String)categoryString + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("flowerpatch.configuration." + path + ".tooltip", description);
                this.add("text.autoconfig.flowerpatch.option." + (String)categoryString + path + ".@Tooltip", description);
            }
        }
    }

    private static class Models
    extends ModelProvider {
        public static final ModelTemplate PATCH_2 = ModelTemplates.create((String)"flowerpatch:patch2", (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS}).extend().renderType("cutout").build();
        public static final ModelTemplate PATCH_3 = ModelTemplates.create((String)"flowerpatch:patch3", (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS}).extend().renderType("cutout").build();
        public static final ModelTemplate PATCH_4 = ModelTemplates.create((String)"flowerpatch:patch4", (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS}).extend().renderType("cutout").build();

        public Models(PackOutput output) {
            super(output, "flowerpatch");
        }

        protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState(blockModels, registryObject.get());
            }
            for (RegistryObject<Block> registryObject : CompatRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState(blockModels, registryObject.get());
            }
        }

        protected void generatePatchState(@NotNull BlockModelGenerators blockModels, Block block) {
            TextureMapping crossMapping;
            PatchBlock patchBlock = (PatchBlock)block;
            if (block instanceof CompatPatchBlock) {
                CompatPatchBlock compatPatchBlock = (CompatPatchBlock)block;
                crossMapping = TextureMapping.singleSlot((TextureSlot)TextureSlot.CROSS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)compatPatchBlock.getNameSpace(), (String)("block/" + compatPatchBlock.getTexturePath())));
            } else {
                crossMapping = TextureMapping.singleSlot((TextureSlot)TextureSlot.CROSS, (ResourceLocation)ResourceLocation.parse((String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)patchBlock.getPatchDelegate().get()).getPath())));
            }
            ResourceLocation patchModel2 = PATCH_2.createWithSuffix(block, "_2", crossMapping, blockModels.modelOutput);
            ResourceLocation patchModel3 = PATCH_3.createWithSuffix(block, "_3", crossMapping, blockModels.modelOutput);
            ResourceLocation patchModel4 = PATCH_4.createWithSuffix(block, "_4", crossMapping, blockModels.modelOutput);
            blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)patchBlock.getProperty()).select((Comparable)Integer.valueOf(2), (Object)BlockModelGenerators.createRotatedVariants((Variant)BlockModelGenerators.plainModel((ResourceLocation)patchModel2))).select((Comparable)Integer.valueOf(3), (Object)BlockModelGenerators.createRotatedVariants((Variant)BlockModelGenerators.plainModel((ResourceLocation)patchModel3))).select((Comparable)Integer.valueOf(4), (Object)BlockModelGenerators.createRotatedVariants((Variant)BlockModelGenerators.plainModel((ResourceLocation)patchModel4)))));
        }
    }
}

