/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.registration;

import com.mrbysco.flowerpatch.Constants;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.MushroomPatchBlock;
import com.mrbysco.flowerpatch.block.WitherRosePatchBlock;
import com.mrbysco.flowerpatch.registration.RegistrationProvider;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class PatchRegistry {
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get(Registries.BLOCK, "flowerpatch");
    public static final RegistryObject<Block> DANDELION_PATCH = PatchRegistry.register("dandelion_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.SATURATION, 7, () -> Blocks.DANDELION, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> POPPY_PATCH = PatchRegistry.register("poppy_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.NIGHT_VISION, 5, () -> Blocks.POPPY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> BLUE_ORCHID_PATCH = PatchRegistry.register("blue_orchid_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.SATURATION, 7, () -> Blocks.BLUE_ORCHID, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_ORCHID).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> ALLIUM_PATCH = PatchRegistry.register("allium_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 4, () -> Blocks.ALLIUM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> AZURE_BLUET_PATCH = PatchRegistry.register("azure_bluet_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.BLINDNESS, 8, () -> Blocks.AZURE_BLUET, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZURE_BLUET).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> RED_TULIP_PATCH = PatchRegistry.register("red_tulip_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.WEAKNESS, 9, () -> Blocks.RED_TULIP, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TULIP).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> ORANGE_TULIP_PATCH = PatchRegistry.register("orange_tulip_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.WEAKNESS, 9, () -> Blocks.ORANGE_TULIP, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_TULIP).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> WHITE_TULIP_PATCH = PatchRegistry.register("white_tulip_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.WEAKNESS, 9, () -> Blocks.WHITE_TULIP, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> PINK_TULIP_PATCH = PatchRegistry.register("pink_tulip_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.WEAKNESS, 9, () -> Blocks.PINK_TULIP, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_TULIP).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> OXEYE_DAISY_PATCH = PatchRegistry.register("oxeye_daisy_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.REGENERATION, 8, () -> Blocks.OXEYE_DAISY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OXEYE_DAISY).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> CORNFLOWER_PATCH = PatchRegistry.register("cornflower_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.JUMP_BOOST, 6, () -> Blocks.CORNFLOWER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CORNFLOWER).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> WITHER_ROSE_PATCH = PatchRegistry.register("wither_rose_patch", properties -> new WitherRosePatchBlock((Holder<MobEffect>)MobEffects.WITHER, () -> Blocks.WITHER_ROSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WITHER_ROSE).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> LILY_OF_THE_VALLEY_PATCH = PatchRegistry.register("lily_of_the_valley_patch", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.POISON, 12, () -> Blocks.LILY_OF_THE_VALLEY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_OF_THE_VALLEY).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> TORCHFLOWER = PatchRegistry.register("torchflower", properties -> new FlowerPatchBlock((Holder<MobEffect>)MobEffects.NIGHT_VISION, 5, () -> Blocks.TORCHFLOWER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCHFLOWER).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    public static final RegistryObject<Block> BROWN_MUSHROOM_PATCH = PatchRegistry.register("brown_mushroom_patch", properties -> new MushroomPatchBlock(() -> Blocks.BROWN_MUSHROOM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_MUSHROOM).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).lightLevel(state -> 1).hasPostProcess((state, getter, pos) -> true));
    public static final RegistryObject<Block> RED_MUSHROOM_PATCH = PatchRegistry.register("red_mushroom_patch", properties -> new MushroomPatchBlock(() -> Blocks.RED_MUSHROOM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess((state, getter, pos) -> true));

    public static RegistryObject<Block> register(String name, Function<BlockBehaviour.Properties, ? extends Block> func, BlockBehaviour.Properties props) {
        return BLOCKS.register(name, () -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Constants.modLoc(name)))));
    }

    public static void loadClass() {
    }
}

